/*
 * Decompiled with CFR 0.152.
 */
package ipl.rg3ied.tp;

import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import ipl.rg3ied.calculus.RG3IRuleIdentifiers;
import ipl.rg3ied.calculus.RG3iRule_Left_Implies;
import ipl.rg3ied.calculus.RG3iRule_Succ;
import ipl.rg3ied.tp.ImplementationError;
import java.util.Iterator;
import java.util.LinkedList;
import jtabwb.engine.NoSuchBacktrackRuleException;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._RuleWithDetails;
import jtabwbx.prop.formula.Formula;

public class MetaBacktrackRule
implements _MetaBacktrackRule,
_RuleWithDetails {
    private final String NAME = "RG3LLC Meta Backtrack rule";
    private _MarkedSingleSuccedentSequent premise;
    private LinkedList<Formula> activeImplications;
    private Formula lastTreatedImplication = null;
    private RG3iRule_Succ succRule;
    private int totalNumberOfRules;
    boolean treatSuccRule;
    Iterator<Formula> iterator;

    public MetaBacktrackRule(_MarkedSingleSuccedentSequent premise, LinkedList<Formula> activeImplications, RG3iRule_Succ succRule) {
        this.premise = premise;
        this.activeImplications = activeImplications == null ? new LinkedList() : activeImplications;
        this.succRule = succRule;
        if (this.activeImplications.size() == 0 && succRule == null) {
            throw new ImplementationError("At least an activeImplication or an instace of succRule is required !");
        }
        this.totalNumberOfRules = this.activeImplications.size() + (succRule == null ? 0 : 1);
        this.treatSuccRule = succRule != null;
        this.iterator = this.activeImplications.iterator();
    }

    @Override
    public String name() {
        return "RG3LLC Meta Backtrack rule";
    }

    @Override
    public _MarkedSingleSuccedentSequent goal() {
        return this.premise;
    }

    @Override
    public _AbstractRule nextRule() throws NoSuchBacktrackRuleException {
        if (this.iterator.hasNext()) {
            this.lastTreatedImplication = this.iterator.next();
            return new RG3iRule_Left_Implies(this.premise, this.lastTreatedImplication);
        }
        if (this.treatSuccRule) {
            this.lastTreatedImplication = null;
            this.treatSuccRule = false;
            return this.succRule;
        }
        throw new NoSuchBacktrackRuleException();
    }

    @Override
    public boolean hasNextRule() {
        return this.treatSuccRule || this.iterator.hasNext();
    }

    @Override
    public int totalNumberOfRules() {
        return this.totalNumberOfRules;
    }

    @Override
    public String getDetails() {
        String str = "rules to apply\n";
        if (this.lastTreatedImplication != null) {
            str = String.valueOf(str) + "- rule [" + RG3IRuleIdentifiers.LEFT_IMPLIES.name() + "] on [" + this.lastTreatedImplication + "]\n";
        }
        if (this.activeImplications != null) {
            for (Formula wff : this.activeImplications) {
                str = String.valueOf(str) + "- rule for: [" + wff + "]\n";
            }
        }
        if (this.succRule != null) {
            str = String.valueOf(str) + "- rule [" + RG3IRuleIdentifiers.SUCC.name() + "]";
        }
        return str;
    }
}

