/*
 * Decompiled with CFR 0.152.
 */
package ipl.rg3ied.launcher;

import ferram.messages.MessageManager;
import ipl.g3ied.launcher.InitialNodeSetBuilder;
import ipl.g3ied.sequents.MarkedSequentImplementations;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import ipl.g3ied.tp.AvailableStrategies;
import ipl.rg3ied.launcher.KripkeModel;
import ipl.rg3ied.launcher.LocalMessageManager;
import ipl.rg3ied.launcher.SelectableSequntImplementations;
import ipl.rg3ied.launcher.SingelExecutionConfigurator;
import ipl.rg3ied.tp.RG3IEDProver;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.Trace;
import jtabwb.launcher.Launcher;
import jtabwb.launcher.ProofSearchData;
import jtabwbx.problems.ILTPProblemReader;
import jtabwbx.problems.JTabWbSimpleProblemReader;
import jtabwbx.problems.PlainProblemReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Main {
    private final String OPTION_PROPERTIES_BUNDLE_NAME = String.valueOf(this.getClass().getPackage().getName()) + ".options";
    private static String FORMULA_SYNTAX_DESCRIPTION = "Syntax of formulas\n  atoms: Java identifiers\nlogical: false, & (and), | (or), ~ (not), -> (implies), <=> (iff)\n  notes: (~ A) is translated as (A -> false)\n         (A <=> B) is translated as ((A -> B) & (B -> A))";
    private static String WELCOME = "Launcher for RG3IED - evaluation driven unprovability calculus for IPL.";
    static final String DEFAULT_MODEL_FILE_NAME = "model.tex";
    static MarkedSequentImplementations DEFAULT_SEQ_IMPLEMENTATION = MarkedSequentImplementations.SEQ_ON_ARRAY;
    private AvailableStrategies DEFAULT_VARIANT = AvailableStrategies.OPT;
    private final Class<RG3IEDProver> RG3I_CLASS = RG3IEDProver.class;
    private final String RG3I_NAME = "rg3ied";
    private MarkedSequentImplementations sequentImplementation = null;
    private SelectableSequntImplementations availableSequentImplementations;
    final Launcher launcher = new Launcher();
    boolean generateModel = false;

    private Main() {
        this.availableSequentImplementations = new SelectableSequntImplementations();
        this.availableSequentImplementations.setDefault(DEFAULT_SEQ_IMPLEMENTATION);
    }

    private Options buildCmdLineOptions() {
        MessageManager msg = new MessageManager(this.OPTION_PROPERTIES_BUNDLE_NAME);
        Options options = new Options();
        options.addOption(Option.builder((String)CmdLineOptionsNames.GENERATE_COUNTER_MODEL).hasArg(false).desc(msg.getMsg("MODEL.description", new Object[]{DEFAULT_MODEL_FILE_NAME})).build());
        options.addOption(Option.builder((String)CmdLineOptionsNames.SEQUENT_IMPLEMENTATIONS).hasArg(true).desc(msg.getMsg("SEQ.description", new Object[]{DEFAULT_SEQ_IMPLEMENTATION.name()})).build());
        options.addOption(Option.builder().longOpt(CmdLineOptionsNames.LONG_NAME_LIST_SEQ_IMPLEMENTATIONS).hasArg(false).desc(msg.getMsg("LSEQ.description", new Object[]{DEFAULT_SEQ_IMPLEMENTATION.name()})).build());
        options.addOption(Option.builder().longOpt(CmdLineOptionsNames.LONG_NAME_LIST_VARIANTS).hasArg(false).desc(msg.getMsg("LVARIANT.description", new Object[]{this.DEFAULT_VARIANT.name()})).build());
        return options;
    }

    private void processCommandLineOptions(String[] args) {
        Launcher.LaunchConfiguration launcherConfiguration = this.launcher.processCmdLineArguments(args);
        CommandLine commandLine = launcherConfiguration.getCommandLine();
        if (commandLine.hasOption(CmdLineOptionsNames.LONG_NAME_LIST_SEQ_IMPLEMENTATIONS)) {
            LocalMessageManager.println("available.sequents.implementations", this.availableSequentImplementations.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (commandLine.hasOption(CmdLineOptionsNames.GENERATE_COUNTER_MODEL)) {
            this.launcher.setTraceGenerationMode(true);
            this.generateModel = true;
        }
        if (commandLine.hasOption(CmdLineOptionsNames.SEQUENT_IMPLEMENTATIONS)) {
            String optValue = commandLine.getOptionValue(CmdLineOptionsNames.SEQUENT_IMPLEMENTATIONS);
            this.sequentImplementation = this.availableSequentImplementations.searchByName(optValue);
            if (this.sequentImplementation == null) {
                LocalMessageManager.println("unknown.option.value", CmdLineOptionsNames.SEQUENT_IMPLEMENTATIONS);
                System.exit(1);
            }
        } else {
            this.sequentImplementation = DEFAULT_SEQ_IMPLEMENTATION;
        }
    }

    private void start(String[] args) {
        this.launcher.configLauncherName(this.getClass().getCanonicalName());
        this.launcher.optConfigWelcomeMessage(WELCOME);
        this.launcher.configStandardInputReader(new PlainProblemReader());
        this.launcher.optConfigInputSyntax(FORMULA_SYNTAX_DESCRIPTION);
        this.launcher.optConfigCmdLineOptions(this.buildCmdLineOptions());
        this.launcher.configProblemDescriptionReader("iltp", ILTPProblemReader.class);
        this.launcher.configProblemDescriptionReader("plain", PlainProblemReader.class);
        this.launcher.configProblemDescriptionReader("jtw", JTabWbSimpleProblemReader.class, true);
        this.launcher.configTheoremProver("rg3ied", this.RG3I_CLASS);
        InitialNodeSetBuilder initialNodeSetBuilder = new InitialNodeSetBuilder();
        this.launcher.configInitialNodeSetBuilder(initialNodeSetBuilder);
        this.processCommandLineOptions(args);
        SingelExecutionConfigurator configurator = new SingelExecutionConfigurator(initialNodeSetBuilder, this.sequentImplementation);
        this.launcher.optConfigSingleExecutionConfigurator(configurator);
        this.launcher.launch();
        ProofSearchData info = this.launcher.getLastProofSearchData();
        if (this.generateModel) {
            Trace trace = info.getTrace();
            if (trace.getStatus() != ProofSearchResult.SUCCESS) {
                LocalMessageManager.println("model.not.success", new Object[0]);
                System.exit(1);
            }
            trace.pruneSuccessful();
            KripkeModel km = KripkeModel.buildFrom(trace);
            try {
                File file = new File(DEFAULT_MODEL_FILE_NAME);
                PrintStream out = new PrintStream(file);
                LocalMessageManager.print("generating.model", new Object[0]);
                km.toLatex(out, (_MarkedSingleSuccedentSequent)trace.getInitialNodeSet());
                LocalMessageManager.println("generating.model.done", file.getAbsolutePath());
            }
            catch (IOException e) {
                LocalMessageManager.println("io.exception", e.getMessage());
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.start(args);
    }

    private static class CmdLineOptionsNames {
        static String GENERATE_COUNTER_MODEL = "model";
        static String SEQUENT_IMPLEMENTATIONS = "seq";
        static String LONG_NAME_LIST_SEQ_IMPLEMENTATIONS = "list-seq";
        static String LONG_NAME_LIST_VARIANTS = "list-var";

        private CmdLineOptionsNames() {
        }
    }
}

