/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.tp;

import ipl.g3i.calculus.G3IRuleIdentifiers;
import ipl.g3i.calculus._G3IAbstractRule;
import ipl.g3ied.calculus.ED_Rule_Left_Implies;
import ipl.g3ied.calculus.ED_Rule_Right_Or;
import ipl.g3ied.evaluation._EvaluationFactory;
import ipl.g3ied.evaluation._Evaluator;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import jtabwb.engine.NoSuchBacktrackRuleException;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._OnRuleResumedListener;
import jtabwb.engine._RuleWithDetails;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;

public class MetaBacktrackRule
implements _MetaBacktrackRule,
_OnRuleResumedListener,
_RuleWithDetails {
    private final String NAME = "G3ied Meta Backtrack rule";
    private _MarkedSingleSuccedentSequent premise;
    private Formula rightOr;
    private Formula[] activeDisjunts;
    private int totalNumberOfRules;
    private _Evaluator evaluator;
    boolean treatRightOr;
    private Iterator<Formula> iteratorLeftImplies;
    private _G3IAbstractRule lastTreatedRule;
    private boolean treatLeftImplies;
    static final String FMT_EVAL = "\nEval(%s, premise)=%s";
    static final String TITLE_EVAL_LEFT_IMPLIES = "\n== EVALUATION OF THE ANTECEDENT OF LEFT-IMPLIES";
    static final String TITLE_EVAL_RIGHT_OR = "\n== EVALUATION OF THE SUBFORMULAS OF RIGHT-OR";

    public MetaBacktrackRule(_EvaluationFactory evaluation, _MarkedSingleSuccedentSequent premise, LinkedList<Formula> activeLeftImplies, Formula rightOr, Formula[] activeDisjunts) {
        this.premise = premise;
        this.evaluator = evaluation.buildEvaluationFunction(premise);
        this.activeDisjunts = activeDisjunts;
        this.rightOr = rightOr;
        this.iteratorLeftImplies = activeLeftImplies == null ? null : activeLeftImplies.iterator();
        this.treatLeftImplies = activeLeftImplies != null;
        this.treatRightOr = rightOr != null;
        this.totalNumberOfRules = (activeLeftImplies != null ? activeLeftImplies.size() : 0) + (this.rightOr == null ? 0 : 1);
    }

    @Override
    public String name() {
        return "G3ied Meta Backtrack rule";
    }

    @Override
    public _MarkedSingleSuccedentSequent goal() {
        return this.premise;
    }

    @Override
    public _AbstractRule nextRule() throws NoSuchBacktrackRuleException {
        if (this.treatRightOr) {
            this.treatRightOr = false;
            this.lastTreatedRule = new ED_Rule_Right_Or(this.premise, this.rightOr, this.activeDisjunts);
            return this.lastTreatedRule;
        }
        if (this.treatLeftImplies) {
            Formula leftImply = this.iteratorLeftImplies.next();
            if (!this.iteratorLeftImplies.hasNext()) {
                this.treatLeftImplies = false;
            }
            this.lastTreatedRule = new ED_Rule_Left_Implies(this.premise, leftImply);
            return this.lastTreatedRule;
        }
        throw new NoSuchBacktrackRuleException();
    }

    @Override
    public boolean hasNextRule() {
        return this.treatRightOr || this.treatLeftImplies;
    }

    @Override
    public int totalNumberOfRules() {
        return this.totalNumberOfRules;
    }

    @Override
    public void onResumed() {
        if (this.lastTreatedRule.getRuleIdentifier() == G3IRuleIdentifiers.LEFT_IMPLIES && ((ED_Rule_Left_Implies)this.lastTreatedRule).lastTreatedConclusionWasTheInvertibleOne()) {
            this.treatLeftImplies = false;
        }
    }

    @Override
    public String getDetails() {
        Formula disj;
        Collection<Formula> implications = this.premise.getAllLeftFormulas(FormulaType.IMPLIES_WFF);
        String str = "";
        if (implications != null) {
            str = TITLE_EVAL_LEFT_IMPLIES;
            for (Formula formula : implications) {
                Formula antecedent = formula.immediateSubformulas()[0];
                String valueOfEvaluation = this.evaluator.eval(antecedent).toString();
                str = String.valueOf(str) + String.format(FMT_EVAL, antecedent.toString(), valueOfEvaluation.toString());
            }
        }
        if ((disj = this.premise.getRightFormulaOfType(FormulaType.OR_WFF)) != null) {
            str = String.valueOf(str) + TITLE_EVAL_RIGHT_OR;
            Formula[] formulaArray = disj.immediateSubformulas();
            int n = formulaArray.length;
            int n2 = 0;
            while (n2 < n) {
                Formula w = formulaArray[n2];
                String valueOfEvaluation = this.evaluator.eval(w).toString();
                str = String.valueOf(str) + String.format(FMT_EVAL, w.toString(), valueOfEvaluation.toString());
                ++n2;
            }
        }
        return str;
    }
}

