/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.tp;

import ipl.g3i.calculus.ClashDetectionRule;
import ipl.g3i.calculus._G3IAbstractRule;
import ipl.g3ied.calculus.ED_Rule_Left_Implies;
import ipl.g3ied.calculus.ED_Rule_Right_Implies;
import ipl.g3ied.calculus.ED_Rule_Right_Implies_Splitted;
import ipl.g3ied.calculus.ED_Rule_Right_Or;
import ipl.g3ied.evaluation.EvaluationValue;
import ipl.g3ied.evaluation._EvaluationFactory;
import ipl.g3ied.evaluation._Evaluator;
import ipl.g3ied.sequents.MarkedSequentLatexFormatter;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import java.util.Collection;
import java.util.LinkedList;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.tracesupport.CTree;
import jtabwb.tracesupport.CTreeNode;
import jtabwb.tracesupport.LatexTranslator;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaLatexFormatter;

public class LatexCtreeFormatter
implements _LatexCTreeFormatter {
    private final String EVAL_MACRO = "\n\\newcommand{\\etildename}{\\tilde{\\mathcal{E}}}\n\\newcommand{\\etilde}[1]{\\etildename(#1)}";
    private _EvaluationFactory evaluation;
    private FormulaLatexFormatter formulaFormatter;
    private MarkedSequentLatexFormatter sequentFormatter;
    private static final String EVALUATIONS_BEGIN = "\\vspace*{4ex}\\begin{minipage}{100em}\n";
    private static final String EVALUATIONS_END = "\\end{minipage}";
    private static final String EVALUATION_LINE = "\\noindent$%s$\\\\\n";
    private static int nodeCounter = 1;
    private static final String EVALUATION_VALUE = "\\etilde{%s,\\sigma_{%d}}=%s";

    public LatexCtreeFormatter(_EvaluationFactory evaluation) {
        this.evaluation = evaluation;
        this.formulaFormatter = new FormulaLatexFormatter();
        this.sequentFormatter = new MarkedSequentLatexFormatter();
    }

    @Override
    public String getPreamble() {
        return "%% \\labseq{Theta}{Gamma}{Delta} writes the sequent Theta;Gamma ==> Delta\n\\newcommand{\\labseq}[3]{\n[\\ifthenelse{\\isempty{#2}}{}{#2}\\, \n\\stackrel{\\textrm{#1}}{\\Longrightarrow}\\, \n\\ifthenelse{\\isempty{#3}}{}{#3}\\, \n]}\n\n\\newcommand{\\etildename}{\\tilde{\\mathcal{E}}}\n\\newcommand{\\etilde}[1]{\\etildename(#1)}";
    }

    @Override
    public String getIntro() {
        return "\\subsection*{Legenda}\n\\begin{itemize}\n\\item The sequent in the conclusion of every rule is indexed by an integer.\\item $\\etildename$ is the evaluation function.\\item $\\etilde{H,\\sigma_n}$ denotes the evaluation of the formula $H$ in the sequent with index $n$.\\end{itemize}\\par\\vspace*{4ex}";
    }

    @Override
    public LatexTranslator.ProofStyle proofStyle() {
        return LatexTranslator.ProofStyle.SEQUENT;
    }

    @Override
    public boolean generateFailureGoalAnnotations() {
        return true;
    }

    @Override
    public String format(_AbstractGoal nodeSet) {
        return this.sequentFormatter.toLatex((_MarkedSingleSuccedentSequent)nodeSet, false);
    }

    @Override
    public String formatRuleName(_AbstractRule rule) {
        _G3IAbstractRule r = (_G3IAbstractRule)rule;
        switch (r.getRuleIdentifier()) {
            case CLASH_DETECTION: {
                return "\\textrm{Id}";
            }
            case LEFT_AND: {
                return "\\land L";
            }
            case LEFT_OR: {
                return "\\lor L";
            }
            case LEFT_IMPLIES: {
                return "\\to L";
            }
            case RIGHT_AND: {
                return "\\land R";
            }
            case RIGHT_OR: {
                return "\\lor R";
            }
            case RIGHT_IMPLIES: {
                if (rule instanceof ED_Rule_Right_Implies) {
                    return "\\to R";
                }
                String index = ((ED_Rule_Right_Implies_Splitted)rule).antecedentOfImplicationEvaluation() == EvaluationValue.T ? "1" : "2";
                return "\\to R_" + index;
            }
        }
        return null;
    }

    @Override
    public boolean generateNodeSetIndex() {
        return true;
    }

    @Override
    public boolean generateRuleIndex() {
        return false;
    }

    @Override
    public String pre(CTree ctree) {
        return null;
    }

    @Override
    public String post(CTree ctree) {
        LinkedList<String> evaluationsDescriptions = new LinkedList<String>();
        CTreeNode root = ctree.getRoot();
        nodeCounter = 1;
        this.generatesEvaluations(evaluationsDescriptions, root);
        String result = EVALUATIONS_BEGIN;
        for (String strEval : evaluationsDescriptions) {
            result = String.valueOf(result) + String.format(EVALUATION_LINE, strEval);
        }
        result = String.valueOf(result) + EVALUATIONS_END;
        return result;
    }

    private void generatesEvaluations(LinkedList<String> lines, CTreeNode node) {
        _G3IAbstractRule appliedRule = (_G3IAbstractRule)node.getAppliedRule();
        _MarkedSingleSuccedentSequent premise = (_MarkedSingleSuccedentSequent)node.getNodeSet();
        _Evaluator eval = this.evaluation.buildEvaluationFunction(premise);
        if (appliedRule instanceof ED_Rule_Left_Implies) {
            this.treatsLeftImplications(eval, lines, premise, nodeCounter);
        } else if (appliedRule instanceof ClashDetectionRule && node.getStatus() == ProofSearchResult.FAILURE) {
            this.treatsLeftImplications(eval, lines, premise, nodeCounter);
            this.treatsRightOr(eval, lines, premise, nodeCounter);
        } else if (appliedRule instanceof ED_Rule_Right_Implies_Splitted) {
            this.treatsRightImplication(eval, lines, premise, nodeCounter);
        } else if (appliedRule instanceof ED_Rule_Right_Or) {
            this.treatsRightOr(eval, lines, premise, nodeCounter);
        }
        ++nodeCounter;
        LinkedList<CTreeNode> successors = node.getSuccessors();
        if (successors != null) {
            for (CTreeNode cTreeNode : successors) {
                this.generatesEvaluations(lines, cTreeNode);
            }
        }
    }

    private void treatsLeftImplications(_Evaluator eval, LinkedList<String> lines, _MarkedSingleSuccedentSequent premise, int nodecounter) {
        Collection<Formula> leftImplications = premise.getAllLeftFormulas(FormulaType.IMPLIES_WFF);
        if (leftImplications == null) {
            return;
        }
        for (Formula formula : leftImplications) {
            this.treatsImplication(eval, lines, formula, premise, nodecounter);
        }
    }

    private void treatsImplication(_Evaluator eval, LinkedList<String> lines, Formula formula, _MarkedSingleSuccedentSequent premise, int nodecounter) {
        Formula[] formulaArray = formula.immediateSubformulas();
        int n = formulaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Formula wff = formulaArray[n2];
            EvaluationValue value = eval.eval(wff);
            lines.add(String.format(EVALUATION_VALUE, this.formulaFormatter.toLatex(wff), nodecounter, value.name()));
            ++n2;
        }
    }

    private void treatsRightImplication(_Evaluator eval, LinkedList<String> lines, _MarkedSingleSuccedentSequent premise, int nodecounter) {
        Formula right = premise.getRightFormulaOfType(FormulaType.IMPLIES_WFF);
        Formula antecedt = right.immediateSubformulas()[0];
        EvaluationValue value = eval.eval(antecedt);
        lines.add(String.format(EVALUATION_VALUE, this.formulaFormatter.toLatex(antecedt), nodecounter, value.name()));
    }

    private void treatsRightOr(_Evaluator eval, LinkedList<String> lines, _MarkedSingleSuccedentSequent premise, int nodecounter) {
        Formula[] disjuncts;
        Formula right = premise.getRightFormulaOfType(FormulaType.OR_WFF);
        if (right == null) {
            return;
        }
        Formula[] formulaArray = disjuncts = right.immediateSubformulas();
        int n = disjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Formula formula = formulaArray[n2];
            EvaluationValue value = eval.eval(formula);
            lines.add(String.format(EVALUATION_VALUE, this.formulaFormatter.toLatex(formula), nodecounter, value.name()));
            ++n2;
        }
    }
}

