/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.tp;

import ipl.g3ied.evaluation.AvailableEvaluations;
import ipl.g3ied.sequents.G3iFormulaFactory;
import ipl.g3ied.sequents.MarkedSequentImplementations;
import ipl.g3ied.tp.AvailableStrategies;
import ipl.g3ied.tp.LatexCtreeFormatter;
import ipl.g3ied.tp.Strategy_GC;
import ipl.g3ied.tp.Strategy_Opt;
import ipl.g3ied.tp.Strategy_OriginalG3i;
import ipl.g3ied.tp.Strategy_Plain;
import ipl.g3ied.tp._EDStrategy;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.engine.ProverName;
import jtabwb.engine._Prover;
import jtabwb.engine._Strategy;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwb.tracesupport._LatexSupport;
import jtabwb.util.ImplementationError;

public class G3IEDProver
implements _Prover,
_LatexSupport {
    public static final String G3IED_DESCRIPTION = "G3i evaluation driven";
    public static final String G3IED_NAME = "g3ied";
    public static final String G3IED_VERSION = "1.0";
    public static final AvailableStrategies DEFAULT_VARIANT = AvailableStrategies.PLAIN;
    public static final MarkedSequentImplementations DEFAULT_SEQ_IMPL = MarkedSequentImplementations.SEQ_ON_BSF;
    public static final AvailableEvaluations DEFAULT_EVALUATION = AvailableEvaluations.COVER;
    private G3iFormulaFactory formulaFactory;
    private _EDStrategy strategy;
    private MarkedSequentImplementations selectedSequentImplementation;
    private AvailableStrategies selectedStrategy;
    private AvailableEvaluations selectedEvaluation;
    private ProverName proverName = new ProverName("g3ied", "1.0");

    public G3IEDProver() {
        this(DEFAULT_VARIANT, DEFAULT_SEQ_IMPL, DEFAULT_EVALUATION);
    }

    public G3IEDProver(AvailableStrategies variant, MarkedSequentImplementations sequentsImplementation, AvailableEvaluations evaluations) {
        this.proverName.setDescription(G3IED_DESCRIPTION);
        this.configure(variant, sequentsImplementation, evaluations);
    }

    public void configure(AvailableStrategies variant, MarkedSequentImplementations impl, AvailableEvaluations eval) {
        this.selectedSequentImplementation = impl != null ? impl : DEFAULT_SEQ_IMPL;
        this.selectedStrategy = variant != null ? variant : DEFAULT_VARIANT;
        this.selectedEvaluation = eval != null ? eval : DEFAULT_EVALUATION;
        this.formulaFactory = new G3iFormulaFactory();
        switch (this.selectedStrategy) {
            case PLAIN: {
                this.strategy = new Strategy_Plain(this.formulaFactory, eval);
                break;
            }
            case G3i: {
                this.strategy = new Strategy_OriginalG3i(this.formulaFactory, eval);
                break;
            }
            case OPT: {
                this.strategy = new Strategy_Opt(this.formulaFactory, eval);
                break;
            }
            case GC: {
                this.strategy = new Strategy_GC(this.formulaFactory, eval);
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
            }
        }
        this.proverName.setVariant("seq=" + this.selectedSequentImplementation.getName() + ", strategy=" + this.selectedStrategy.getName() + ", evaluation=" + this.selectedEvaluation.getName());
    }

    @Override
    public _Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ProverName getProverName() {
        return this.proverName;
    }

    @Override
    public ProvabilityStatus statusFor(ProofSearchResult result) {
        switch (result) {
            case SUCCESS: {
                return ProvabilityStatus.PROVABLE;
            }
            case FAILURE: {
                return ProvabilityStatus.UNPROVABLE;
            }
        }
        return null;
    }

    @Override
    public _LatexCTreeFormatter getLatexProofFormatter() {
        return new LatexCtreeFormatter(this.strategy.getEvaluationFactory());
    }
}

