/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.sequents;

import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import jtabwbx.prop.formula.FormulaLatexFormatter;

public class MarkedSequentLatexFormatter {
    public static final String LATEX_MACROS = "%% \\labseq{Theta}{Gamma}{Delta} writes the sequent Theta;Gamma ==> Delta\n\\newcommand{\\labseq}[3]{\n[\\ifthenelse{\\isempty{#2}}{}{#2}\\, \n\\stackrel{\\textrm{#1}}{\\Longrightarrow}\\, \n\\ifthenelse{\\isempty{#3}}{}{#3}\\, \n]}\n";
    static final String SEQ_FORMAT = "\\labseq{%s}{%s}{%s}";
    private FormulaLatexFormatter formulaFormatter;

    public MarkedSequentLatexFormatter() {
        this.formulaFormatter = new FormulaLatexFormatter();
    }

    public MarkedSequentLatexFormatter(FormulaLatexFormatter formulaFormatter) {
        this.formulaFormatter = formulaFormatter;
    }

    public String toLatex(_MarkedSingleSuccedentSequent seq, boolean printMarker) {
        String mark = printMarker ? (seq.isBlocked() ? "b" : "u") : "";
        String s = String.format(SEQ_FORMAT, mark, this.formulaFormatter.toLatex(seq.getAllLeftFormulas(), ", "), this.formulaFormatter.toLatex(seq.getRight()));
        return s;
    }

    public String toLatex(_MarkedSingleSuccedentSequent seq) {
        return this.toLatex(seq, true);
    }
}

