/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ibu.tp;

import java.util.ArrayList;
import java.util.LinkedList;

public class VarargsTypeChecker {
    private final String MSG_ERROR = "Varargs specification error:";
    private final String MSG_WRONG_NUMBER_OF_ARGS = "--Wrong number of arguments: expected [%d], found [%d].";
    private final String MSG_WRONG_ARG_TYPE = "--Arg [%d] wrong type: expected [%s], found [%s].";
    private final String MSG_UNEXPECTED_TYPE = "--Unexpected arg [%d] of type [%s].";
    private ArrayList<Class<?>> argumentTypes = new ArrayList();

    public void addArgumentType(Class<?> argType) {
        this.argumentTypes.add(argType);
    }

    public void addArgumentType(Class<?> ... argType) {
        int i = 0;
        while (i < argType.length) {
            this.argumentTypes.add(argType[i]);
            ++i;
        }
    }

    public CheckResult check(Object ... args) {
        boolean checkResult = true;
        LinkedList<String> msgs = new LinkedList<String>();
        if (this.argumentTypes.size() != args.length) {
            msgs.add(String.format("--Wrong number of arguments: expected [%d], found [%d].", this.argumentTypes.size(), args.length));
            checkResult = false;
        }
        int i = 0;
        while (i < args.length) {
            Class<?> expected = null;
            if (i < this.argumentTypes.size()) {
                expected = this.argumentTypes.get(i);
            }
            if (expected == null) {
                msgs.add(String.format("--Unexpected arg [%d] of type [%s].", i, args[i].getClass().getCanonicalName()));
                checkResult = false;
            } else if (!expected.isAssignableFrom(args[i].getClass())) {
                msgs.add(String.format("--Arg [%d] wrong type: expected [%s], found [%s].", i, expected.getCanonicalName(), args[i].getClass().getCanonicalName()));
                checkResult = false;
            }
            ++i;
        }
        CheckResult result = new CheckResult();
        result.result = checkResult;
        result.checkMessages = msgs.size() == 0 ? null : msgs.toArray(new String[msgs.size()]);
        return result;
    }

    public class CheckResult {
        private boolean result;
        private String[] checkMessages;

        public boolean checkResult() {
            return this.result;
        }

        public String[] getCheckMessages() {
            return this.checkMessages;
        }

        public String getMessage() {
            if (this.checkMessages == null) {
                return null;
            }
            StringBuffer result = new StringBuffer();
            result.append("Varargs specification error:");
            result.append("\n");
            int i = 0;
            while (i < this.checkMessages.length) {
                result.append(this.checkMessages[i]);
                if (i < this.checkMessages.length) {
                    result.append("\n");
                }
                ++i;
            }
            return result.toString();
        }
    }
}

