/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ibu.tp;

import ipl.g3ibu.evaluation.AvailableGbuEvaluations;
import ipl.g3ibu.tp.CtreeLatexFormatter;
import ipl.g3ibu.tp.DynamicStrategy;
import ipl.g3ibu.tp.DynamicStrategyOnBSF;
import ipl.g3ied.sequents.G3iFormulaFactory;
import ipl.g3ied.sequents.MarkedSequentImplementations;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.engine.ProverName;
import jtabwb.engine._Prover;
import jtabwb.engine._Strategy;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwb.tracesupport._LatexSupport;
import jtabwb.util.ImplementationError;

public class G3ibuProver
implements _Prover,
_LatexSupport {
    public static String GBU_DESCRIPTION = "Gbu Sequent Calculus for propositional Intuitionistic Logic.";
    public static String GBU_NAME = "g3ibu";
    public static String GBU_VERSION = "1.0";
    public static MarkedSequentImplementations DEFAULT_SEQ_IMPLEMENTATION = MarkedSequentImplementations.SEQ_ON_BSF;
    public static AvailableGbuEvaluations DEFAULT_EVALUATION = AvailableGbuEvaluations.MINIMAL;
    private ProverName proverName;
    private _Strategy strategy;

    public G3ibuProver() {
        this.configure(new G3iFormulaFactory(), DEFAULT_SEQ_IMPLEMENTATION, DEFAULT_EVALUATION);
    }

    @Override
    public _Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ProverName getProverName() {
        return this.proverName;
    }

    @Override
    public ProvabilityStatus statusFor(ProofSearchResult result) {
        switch (result) {
            case SUCCESS: {
                return ProvabilityStatus.PROVABLE;
            }
            case FAILURE: {
                return ProvabilityStatus.UNPROVABLE;
            }
        }
        throw new ImplementationError();
    }

    @Override
    public _LatexCTreeFormatter getLatexProofFormatter() {
        return new CtreeLatexFormatter();
    }

    public void configure(G3iFormulaFactory factory, MarkedSequentImplementations selectedImplementation, AvailableGbuEvaluations selectedEvaluation) {
        switch (selectedImplementation) {
            case SEQ_ON_ARRAY: 
            case SEQ_ON_LIST: 
            case SEQ_ON_BITSET: {
                this.strategy = new DynamicStrategy(factory, selectedEvaluation);
                break;
            }
            case SEQ_ON_BSF: {
                this.strategy = new DynamicStrategyOnBSF(factory, selectedEvaluation);
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
            }
        }
        String variantName = "seq=" + selectedImplementation.getName() + ", eval=" + selectedEvaluation.getName();
        this.proverName = new ProverName(GBU_NAME, GBU_VERSION, variantName);
    }
}

