/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ibu.tp;

import ipl.g3i.calculus.G3IRuleIdentifiers;
import ipl.g3ibu.calculus.G3ibuCalculus;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import jtabwb.engine.NoSuchBacktrackRuleException;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.formula.Formula;

public class G3ibuMetaBacktrackRule
implements _MetaBacktrackRule {
    private final String NAME = "G3ibu Meta Backtrack rule";
    private G3ibuCalculus calculus;
    private _MarkedSingleSuccedentSequent premise;
    private LinkedList<Formula> toTreat;
    private Iterator<Formula> iterator;
    private int totalNumberOfRules;

    public G3ibuMetaBacktrackRule(G3ibuCalculus calculus, _MarkedSingleSuccedentSequent premise, Collection<Formula> leftImplies, Formula rightOr) {
        if ((leftImplies == null || leftImplies.size() == 0) && rightOr == null) {
            throw new ImplementationError("At least a formula must be provided.");
        }
        this.calculus = calculus;
        this.premise = premise;
        this.toTreat = new LinkedList();
        if (rightOr != null) {
            this.toTreat.add(rightOr);
        }
        if (leftImplies != null) {
            this.toTreat.addAll(leftImplies);
        }
        this.iterator = this.toTreat.iterator();
        this.totalNumberOfRules = this.toTreat.size();
    }

    @Override
    public String name() {
        return "G3ibu Meta Backtrack rule";
    }

    @Override
    public _MarkedSingleSuccedentSequent goal() {
        return this.premise;
    }

    @Override
    public _AbstractRule nextRule() throws NoSuchBacktrackRuleException {
        try {
            Formula mainFormula = this.iterator.next();
            switch (mainFormula.mainConnective()) {
                case IMPLIES: {
                    return this.calculus.getRule(G3IRuleIdentifiers.LEFT_IMPLIES, this.premise, mainFormula);
                }
                case OR: {
                    return this.calculus.getRule(G3IRuleIdentifiers.RIGHT_OR, this.premise, mainFormula);
                }
            }
            throw new ImplementationError();
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBacktrackRuleException();
        }
    }

    @Override
    public boolean hasNextRule() {
        return this.iterator.hasNext();
    }

    @Override
    public int totalNumberOfRules() {
        return this.totalNumberOfRules;
    }
}

