/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ibu.tp;

import ipl.g3i.calculus._G3IAbstractRule;
import ipl.g3ibu.calculus.G3ibu_Rule_Right_Implies;
import ipl.g3ibu.evaluation.GbuEvaluationValue;
import ipl.g3ied.sequents.MarkedSequentLatexFormatter;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import java.util.LinkedList;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.tracesupport.CTree;
import jtabwb.tracesupport.CTreeNode;
import jtabwb.tracesupport.LatexTranslator;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaLatexFormatter;

class CtreeLatexFormatter
implements _LatexCTreeFormatter {
    private final String EVAL_MACRO = "\n\\newcommand{\\etildename}{\\tilde{\\mathcal{E}}}\n\\newcommand{\\etilde}[1]{\\etildename(#1)}";
    private FormulaLatexFormatter formulaFormatter = new FormulaLatexFormatter();
    private MarkedSequentLatexFormatter sequentFormatter = new MarkedSequentLatexFormatter();
    private static final String EVALUATIONS_BEGIN = "\\vspace*{4ex}\\begin{minipage}{100em}\n";
    private static final String EVALUATIONS_END = "\\end{minipage}";
    private static final String EVALUATION_LINE = "\\noindent$%s$\\\\\n";
    private static int nodeCounter = 1;
    private static final String EVALUATION_TRUE = "\\Gamma_{%d}  \\models_{\\mathcal{E}} %s";
    private static final String EVALUATION_FALSE = "\\Gamma_{%d}  \\not\\models_{\\mathcal{E}} %s";

    @Override
    public String getPreamble() {
        return "%% \\labseq{Theta}{Gamma}{Delta} writes the sequent Theta;Gamma ==> Delta\n\\newcommand{\\labseq}[3]{\n[\\ifthenelse{\\isempty{#2}}{}{#2}\\, \n\\stackrel{\\textrm{#1}}{\\Longrightarrow}\\, \n\\ifthenelse{\\isempty{#3}}{}{#3}\\, \n]}\n\n\\newcommand{\\etildename}{\\tilde{\\mathcal{E}}}\n\\newcommand{\\etilde}[1]{\\etildename(#1)}";
    }

    @Override
    public String getIntro() {
        return "\\subsection*{Legenda}\n\\begin{itemize}\n\\item The sequent in the conclusion of every rule is indexed by an integer. \\item $\\sigma_i$ is an abbreviation for the sequent with index $i$ and $\\Gamma_i$ denotes the left-hand side of sequent $\\sigma_i$.\\item $\\mathcal{E}$ is the evaluation function.\\end{itemize}\\par\\vspace*{4ex}";
    }

    @Override
    public LatexTranslator.ProofStyle proofStyle() {
        return LatexTranslator.ProofStyle.SEQUENT;
    }

    @Override
    public boolean generateFailureGoalAnnotations() {
        return false;
    }

    @Override
    public String format(_AbstractGoal nodeSet) {
        return this.sequentFormatter.toLatex((_MarkedSingleSuccedentSequent)nodeSet);
    }

    @Override
    public String formatRuleName(_AbstractRule rule) {
        _G3IAbstractRule r = (_G3IAbstractRule)rule;
        switch (r.getRuleIdentifier()) {
            case CLASH_DETECTION: {
                return "\\textrm{Id}";
            }
            case LEFT_AND: {
                return "\\land L";
            }
            case LEFT_OR: {
                return "\\lor L";
            }
            case LEFT_IMPLIES: {
                return "\\to L";
            }
            case RIGHT_AND: {
                return "\\land R";
            }
            case RIGHT_OR: {
                return "\\lor R";
            }
            case RIGHT_IMPLIES: {
                if (((G3ibu_Rule_Right_Implies)rule).evaluationResult() == GbuEvaluationValue.T) {
                    return "\\to R_1";
                }
                return "\\to R_2";
            }
        }
        return null;
    }

    @Override
    public boolean generateNodeSetIndex() {
        return true;
    }

    @Override
    public boolean generateRuleIndex() {
        return false;
    }

    @Override
    public String pre(CTree ctree) {
        return null;
    }

    @Override
    public String post(CTree ctree) {
        LinkedList<String> evaluationsDescriptions = new LinkedList<String>();
        CTreeNode root = ctree.getRoot();
        nodeCounter = 1;
        this.generatesEvaluations(evaluationsDescriptions, root);
        String result = EVALUATIONS_BEGIN;
        for (String strEval : evaluationsDescriptions) {
            result = String.valueOf(result) + String.format(EVALUATION_LINE, strEval);
        }
        result = String.valueOf(result) + EVALUATIONS_END;
        return result;
    }

    private void generatesEvaluations(LinkedList<String> lines, CTreeNode node) {
        _G3IAbstractRule appliedRule = (_G3IAbstractRule)node.getAppliedRule();
        if (appliedRule instanceof G3ibu_Rule_Right_Implies) {
            G3ibu_Rule_Right_Implies rightImplies = (G3ibu_Rule_Right_Implies)appliedRule;
            Formula antecedent = rightImplies.mainFormula().immediateSubformulas()[0];
            String fmt = rightImplies.evaluationResult() == GbuEvaluationValue.T ? EVALUATION_TRUE : EVALUATION_FALSE;
            lines.add(String.format(fmt, nodeCounter, this.formulaFormatter.toLatex(antecedent)));
        }
        ++nodeCounter;
        LinkedList<CTreeNode> successors = node.getSuccessors();
        if (successors != null) {
            for (CTreeNode cTreeNode : successors) {
                this.generatesEvaluations(lines, cTreeNode);
            }
        }
    }
}

