/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ibu.launcher;

import ferram.messages.MessageManager;
import ipl.g3ibu.evaluation.AvailableGbuEvaluations;
import ipl.g3ibu.launcher.InitialNodeSetBuilder;
import ipl.g3ibu.launcher.KripkeModel;
import ipl.g3ibu.launcher.LocalMessageManager;
import ipl.g3ibu.launcher.SelectableEvaluations;
import ipl.g3ibu.launcher.SelectableSequentsImplementation;
import ipl.g3ibu.launcher.SingelExecutionConfigurator;
import ipl.g3ibu.tp.G3ibuProver;
import ipl.g3ied.sequents.MarkedSequentImplementations;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import iplj.rgi3bu.tp.RG3ibuProver;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.Trace;
import jtabwb.launcher.ConfiguredTheoremProver;
import jtabwb.launcher.Launcher;
import jtabwb.launcher.ProofSearchData;
import jtabwbx.problems.ILTPProblemReader;
import jtabwbx.problems.JTabWbSimpleProblemReader;
import jtabwbx.problems.PlainProblemReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Main {
    private final String OPTION_PROPERTIES_BUNDLE_NAME = String.valueOf(this.getClass().getPackage().getName()) + ".messages";
    private static String FORMULA_SYNTAX_DESCRIPTION = "Syntax of formulas\n  atoms: Java identifiers\nlogical: false, & (and), | (or), ~ (not), -> (implies), <=> (iff)\n  notes: (~ A) is translated as (A -> false)\n         (A <=> B) is translated as ((A -> B) & (B -> A))";
    static final String DEFAULT_MODEL_FILE_NAME = "model.tex";
    private final Class<G3ibuProver> G3IBU_PROVER_CLASS = G3ibuProver.class;
    private final String G3IBU_PROVER_NAME = "g3ibu";
    private final Class<RG3ibuProver> RG3IBU_PROVER_CLASS = RG3ibuProver.class;
    private final String RG3IBU_PROVER_NAME = "rg3ibu";
    static MarkedSequentImplementations DEFAULT_SEQ_IMPLEMENTATION = G3ibuProver.DEFAULT_SEQ_IMPLEMENTATION;
    static AvailableGbuEvaluations DEFAULT_EVALUATION = G3ibuProver.DEFAULT_EVALUATION;
    private Launcher launcher = new Launcher();
    private boolean generateModel = false;
    private SelectableEvaluations selectableEvaluations;
    private SelectableSequentsImplementation availableSequentImplementations = new SelectableSequentsImplementation();
    private AvailableGbuEvaluations selectedEvaluation;
    private MarkedSequentImplementations selectedSequentImplementation = null;

    private Main() {
        this.availableSequentImplementations.setDefault(DEFAULT_SEQ_IMPLEMENTATION);
        this.selectableEvaluations = new SelectableEvaluations();
        this.selectableEvaluations.setDefault(DEFAULT_EVALUATION);
    }

    private Options buildCmdLineOptions() {
        MessageManager msg = new MessageManager(this.OPTION_PROPERTIES_BUNDLE_NAME);
        Options options = new Options();
        options.addOption(Option.builder((String)CmdLineOptionsNames.GENERATE_COUNTER_MODEL).hasArg(false).desc(msg.getMsg("MODEL.description", new Object[]{DEFAULT_MODEL_FILE_NAME})).build());
        options.addOption(Option.builder((String)CmdLineOptionsNames.SEQUENT_IMPLEMENTATION).hasArg(true).desc(msg.getMsg("SEQ.description", new Object[]{this.availableSequentImplementations.getNames()})).build());
        options.addOption(Option.builder().longOpt(CmdLineOptionsNames.LONG_NAME_LIST_SEQ_IMPLEMENTATIONS).hasArg(false).desc(msg.getMsg("LSEQ.description")).build());
        options.addOption(Option.builder((String)CmdLineOptionsNames.EVALUATION).hasArg(true).desc(msg.getMsg("EVALUATION.description", new Object[]{this.selectableEvaluations.getNames()})).build());
        options.addOption(Option.builder().longOpt(CmdLineOptionsNames.LONG_NAME_LIST_EVALUATIONS).hasArg(false).desc(msg.getMsg("LEVAL.description")).build());
        return options;
    }

    private void processCommandLineOptions(String[] args) {
        Launcher.LaunchConfiguration launcherConfiguration = this.launcher.processCmdLineArguments(args);
        CommandLine commandLine = launcherConfiguration.getCommandLine();
        if (commandLine.hasOption(CmdLineOptionsNames.LONG_NAME_LIST_SEQ_IMPLEMENTATIONS)) {
            LocalMessageManager.println("available.sequents.implementations", this.availableSequentImplementations.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (commandLine.hasOption(CmdLineOptionsNames.LONG_NAME_LIST_EVALUATIONS)) {
            LocalMessageManager.println("available.evaluations", this.selectableEvaluations.getNamedArgumentsDescription());
            System.exit(0);
        }
        if (commandLine.hasOption(CmdLineOptionsNames.EVALUATION)) {
            String varName = commandLine.getOptionValue(CmdLineOptionsNames.EVALUATION);
            AvailableGbuEvaluations eval = this.selectableEvaluations.searchByName(varName);
            if (eval == null) {
                LocalMessageManager.println("available.evaluation.wrong", varName);
                System.exit(1);
            } else {
                this.selectedEvaluation = eval;
            }
        } else {
            this.selectedEvaluation = DEFAULT_EVALUATION;
        }
        if (commandLine.hasOption(CmdLineOptionsNames.GENERATE_COUNTER_MODEL)) {
            ConfiguredTheoremProver prover = launcherConfiguration.getSelectedProver();
            if (prover.getName().equals("g3ibu")) {
                LocalMessageManager.println("option.model.not.applicable", CmdLineOptionsNames.GENERATE_COUNTER_MODEL, "g3ibu");
                System.exit(1);
            }
            this.launcher.setTraceGenerationMode(true);
            this.generateModel = true;
        }
        if (commandLine.hasOption(CmdLineOptionsNames.SEQUENT_IMPLEMENTATION)) {
            String optValue = commandLine.getOptionValue(CmdLineOptionsNames.SEQUENT_IMPLEMENTATION);
            this.selectedSequentImplementation = this.availableSequentImplementations.searchByName(optValue);
            if (this.selectedSequentImplementation == null) {
                LocalMessageManager.println("unknown.option.value", optValue, CmdLineOptionsNames.SEQUENT_IMPLEMENTATION);
                System.exit(1);
            }
        } else {
            this.selectedSequentImplementation = DEFAULT_SEQ_IMPLEMENTATION;
        }
    }

    MarkedSequentImplementations getSelectedSequentImplementation() {
        return this.selectedSequentImplementation;
    }

    private void start(String[] args) {
        this.launcher.configLauncherName(this.getClass().getCanonicalName());
        this.launcher.configStandardInputReader(new PlainProblemReader());
        this.launcher.optConfigInputSyntax(FORMULA_SYNTAX_DESCRIPTION);
        this.launcher.optConfigCmdLineOptions(this.buildCmdLineOptions());
        this.launcher.configProblemDescriptionReader("iltp", ILTPProblemReader.class);
        this.launcher.configProblemDescriptionReader("plain", PlainProblemReader.class);
        this.launcher.configProblemDescriptionReader("jtw", JTabWbSimpleProblemReader.class, true);
        this.launcher.configTheoremProver("g3ibu", this.G3IBU_PROVER_CLASS, true);
        this.launcher.configTheoremProver("rg3ibu", this.RG3IBU_PROVER_CLASS);
        InitialNodeSetBuilder initialNodeSetBuilder = new InitialNodeSetBuilder();
        this.launcher.configInitialNodeSetBuilder(initialNodeSetBuilder);
        this.processCommandLineOptions(args);
        SingelExecutionConfigurator configurator = new SingelExecutionConfigurator(initialNodeSetBuilder, this.selectedSequentImplementation, this.selectedEvaluation);
        this.launcher.optConfigSingleExecutionConfigurator(configurator);
        this.launcher.launch();
        ProofSearchData info = this.launcher.getLastProofSearchData();
        if (this.generateModel) {
            Trace trace = info.getTrace();
            if (trace.getStatus() != ProofSearchResult.SUCCESS) {
                LocalMessageManager.println("model.not.success", new Object[0]);
                System.exit(1);
            }
            trace.pruneSuccessful();
            KripkeModel km = KripkeModel.buildFrom(trace);
            try {
                File file = new File(DEFAULT_MODEL_FILE_NAME);
                PrintStream out = new PrintStream(file);
                LocalMessageManager.print("generating.model", new Object[0]);
                km.toLatex(out, (_MarkedSingleSuccedentSequent)trace.getInitialNodeSet());
                LocalMessageManager.println("generating.model.done", file.getAbsolutePath());
            }
            catch (IOException e) {
                LocalMessageManager.println("io.exception", e.getMessage());
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.start(args);
    }

    private static class CmdLineOptionsNames {
        static String GENERATE_COUNTER_MODEL = "model";
        static String SEQUENT_IMPLEMENTATION = "seq";
        static String LONG_NAME_LIST_SEQ_IMPLEMENTATIONS = "list-seq";
        static String EVALUATION = "eval";
        static String LONG_NAME_LIST_EVALUATIONS = "lleval";

        private CmdLineOptionsNames() {
        }
    }
}

