/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ibu.launcher;

import ipl.g3ibu.launcher.ImplementationError;
import ipl.g3ibu.launcher.KripkeModelLatexGenerator;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import ipl.rg3ibu.calculus.RG3ibu_ClashDetectionRule;
import ipl.rg3ibu.calculus.RG3ibu_Rule_Succ;
import ipl.rg3ibu.calculus._RG3ibuAbstractRule;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import jtabwb.engine.Trace;
import jtabwb.engine.TraceNode;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;

public class KripkeModel {
    private String INDENTATION = "  ";
    private int name;
    private LinkedList<KripkeModel> successors;
    private LinkedList<Formula> forcedPropositions;
    static int nodeCounter = 0;

    public KripkeModel(int name) {
        this.name = name;
        this.successors = null;
        this.forcedPropositions = null;
    }

    public void addSuccessor(KripkeModel successor) {
        if (this.successors == null) {
            this.successors = new LinkedList();
        }
        this.successors.addLast(successor);
    }

    public void addForcedProposition(Collection<Formula> propositions) {
        if (propositions == null || propositions.size() == 0) {
            return;
        }
        if (this.forcedPropositions == null) {
            this.forcedPropositions = new LinkedList();
        }
        for (Formula f : propositions) {
            this.forcedPropositions.addLast(f);
        }
    }

    public int getName() {
        return this.name;
    }

    public LinkedList<KripkeModel> getSuccessors() {
        return this.successors;
    }

    public LinkedList<Formula> getForcedPropositions() {
        return this.forcedPropositions;
    }

    public String toString() {
        return this.toStringIndent("");
    }

    private String toStringIndent(String indent) {
        String str = String.valueOf(indent) + "[" + this.name + "]: " + this.forcing() + "\n";
        if (this.successors == null) {
            return str;
        }
        indent = String.valueOf(indent) + this.INDENTATION;
        for (KripkeModel succ : this.successors) {
            str = String.valueOf(str) + succ.toStringIndent(indent);
        }
        return str;
    }

    private String forcing() {
        if (this.forcedPropositions == null) {
            return "";
        }
        Formula[] a = this.forcedPropositions.toArray(new Formula[this.forcedPropositions.size()]);
        String str = "";
        int i = 0;
        while (i < a.length) {
            str = String.valueOf(str) + a[i].toString() + (i < a.length - 1 ? ", " : "");
            ++i;
        }
        return str;
    }

    static KripkeModel buildFrom(Trace trace) {
        TraceNode traceHead = trace.getProofSearchTree();
        LinkedList<KripkeModel> setOfKrikeModels = KripkeModel._build(traceHead);
        if (setOfKrikeModels.size() != 1) {
            throw new ImplementationError();
        }
        return setOfKrikeModels.getFirst();
    }

    private static LinkedList<KripkeModel> _build(TraceNode node) {
        _MarkedSingleSuccedentSequent premise = (_MarkedSingleSuccedentSequent)node.getPremise();
        if (premise.isBlocked()) {
            LinkedList<TraceNode> children = node.getChildren();
            if (children == null) {
                return null;
            }
            LinkedList<KripkeModel> models = new LinkedList<KripkeModel>();
            for (TraceNode traceNode : children) {
                LinkedList<KripkeModel> childModels = KripkeModel._build(traceNode);
                if (childModels == null) continue;
                models.addAll(childModels);
            }
            if (models.size() == 0) {
                return null;
            }
            return models;
        }
        _RG3ibuAbstractRule rule = (_RG3ibuAbstractRule)node.getAppliedRule();
        switch (rule.getRuleIdentifier()) {
            case CLASH_DETECTION: {
                _MarkedSingleSuccedentSequent sequent = ((RG3ibu_ClashDetectionRule)rule).goal();
                KripkeModel kw = new KripkeModel(nodeCounter++);
                kw.addForcedProposition(sequent.getAllLeftFormulas(FormulaType.ATOMIC_WFF));
                LinkedList<KripkeModel> list = new LinkedList<KripkeModel>();
                list.add(kw);
                return list;
            }
            case LEFT_AND: 
            case RIGHT_AND: 
            case LEFT_OR: 
            case LEFT_IMPLIES: 
            case RIGHT_IMPLIES: {
                LinkedList<TraceNode> successors = node.getChildren();
                if (successors.size() != 1) {
                    throw new ImplementationError();
                }
                return KripkeModel._build(successors.getFirst());
            }
            case SUCC: {
                KripkeModel kw = new KripkeModel(nodeCounter++);
                LinkedList<KripkeModel> submodels = new LinkedList<KripkeModel>();
                LinkedList<TraceNode> successors = node.getChildren();
                for (TraceNode s : successors) {
                    LinkedList<KripkeModel> childModels = KripkeModel._build(s);
                    if (childModels == null) continue;
                    submodels.addAll(childModels);
                }
                if (submodels.size() > 0) {
                    for (KripkeModel submodel : submodels) {
                        kw.addSuccessor(submodel);
                    }
                }
                _MarkedSingleSuccedentSequent sequent = ((RG3ibu_Rule_Succ)rule).premise();
                kw.addForcedProposition(sequent.getAllLeftFormulas(FormulaType.ATOMIC_WFF));
                LinkedList<KripkeModel> list = new LinkedList<KripkeModel>();
                list.add(kw);
                return list;
            }
        }
        throw new ImplementationError();
    }

    public void toLatex(PrintStream out, _MarkedSingleSuccedentSequent goal) {
        KripkeModelLatexGenerator lg = new KripkeModelLatexGenerator(this, goal);
        lg.generateLatex(out);
    }
}

