grammar JTWProblem;

@header{
  package jtabwbx.problems;
}

problem :
  //SEPARATOR formula_name  status  SEPARATOR
  definitions
  formula EOF
  // (SEPARATOR | EOF)
 ;

definitions: 
  (definition)*
  ;
  
definition : 'def'  ID '=' formula ';';
  
formula: wff;  

//formula_name : 'Formula' ':' ID; 

//status : 'Status' ':' ('unprovable' | 'provable' | 'unknown') ;

//other : .*? ;

wff :   '~' wff            # Neg
    |   'box' wff          # Box
    |   'dia' wff          # Dia
    |   wff op='&' wff     # And
    |   wff op='|' wff     # Or
    |   <assoc=right>  wff (op='=>' | op='->') wff  # Imp
    |   <assoc=right>  wff (op='<=>' | op='<->') wff   # Eq
    |   '(' wff ')'                      # Par
    |   ID                               # Prop 
    ;

//SEPARATOR: '-'+   ;

LINE_COMMENT : '%' .*? '\r'? '\n' -> skip ; // Match "//" stuff '\n'

//STRING : '"' .*? '"' ; // match anything in "..."

WS: [ \t\r\n]+ -> skip;  // skip white-spaces

ID : ID_LETTER (ID_LETTER | DIGIT )* ; 
ID_LETTER : 'a'..'z'|'A'..'Z'|'_';
DIGIT : '0'..'9' ;
//SPECIAL : '.' | '+';

 
 




