/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Collection;
import java.util.LinkedList;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.FormulaSetOnList;
import jtabwbx.prop.formula._SingleSuccedentSequent;

public class SingleSuccedentSequentOnLists
implements _SingleSuccedentSequent,
Cloneable {
    private FormulaSetOnList[] left;
    private Formula right;
    private FormulaFactory formulaFactory;

    public SingleSuccedentSequentOnLists(FormulaFactory formulaFactory) {
        this.formulaFactory = formulaFactory;
        this.left = new FormulaSetOnList[FormulaType.values().length];
    }

    @Override
    public Collection<Formula> getAllLeftFormulas() {
        FormulaSetOnList set = new FormulaSetOnList();
        for (FormulaSetOnList s : this.left) {
            if (s == null) continue;
            set.addAll(s);
        }
        if (set.cardinality() == 0) {
            return null;
        }
        return set.getAllFormulas();
    }

    @Override
    public Collection<Formula> getAllLeftFormulas(FormulaType formulaType) {
        int setIndex = formulaType.ordinal();
        if (this.left[setIndex] == null) {
            return null;
        }
        return this.left[setIndex].getAllFormulas();
    }

    @Override
    public Formula getRight() {
        return this.right;
    }

    @Override
    public void addLeft(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        if (this.left[index] == null) {
            this.left[index] = new FormulaSetOnList();
            this.left[index].add(wff);
        } else if (!this.left[index].contains(wff)) {
            this.left[index].add(wff);
        }
    }

    @Override
    public void addRight(Formula wff) {
        this.right = wff;
    }

    private Formula getLeftFormula(int index) {
        if (this.left[index] != null) {
            return this.left[index].getFirst();
        }
        return null;
    }

    @Override
    public Formula getLeft(FormulaType formulaType) {
        return this.getLeftFormula(formulaType.ordinal());
    }

    @Override
    public Formula getLeft() {
        for (FormulaSetOnList list : this.left) {
            if (list == null) continue;
            return (Formula)((LinkedList)list).getFirst();
        }
        return null;
    }

    @Override
    public Formula getRightFormulaOfType(FormulaType formulaType) {
        if (this.right == null) {
            return null;
        }
        if (formulaType == FormulaType.getFormulaType(this.right)) {
            return this.right;
        }
        return null;
    }

    @Override
    public boolean removeLeft(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        if (this.left[index] != null) {
            boolean result = this.left[index].remove(wff);
            if (this.left[index].cardinality() == 0) {
                this.left[index] = null;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean removeRight() {
        if (this.right != null) {
            this.right = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIdentityAxiom() {
        if (this.right == null) {
            return false;
        }
        FormulaType type = FormulaType.getFormulaType(this.right);
        int index = type.ordinal();
        return this.left[index] != null && this.left[index].contains(this.right);
    }

    @Override
    public boolean isFalseInLeftSide() {
        return this.containsLeft(this.formulaFactory.FALSE);
    }

    @Override
    public boolean isRightFormulaTrue() {
        return this.right == null ? false : this.right.isTrue();
    }

    @Override
    public boolean containsLeft(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        return this.left[index] != null && this.left[index].contains(wff);
    }

    @Override
    public SingleSuccedentSequentOnLists clone() {
        try {
            SingleSuccedentSequentOnLists cloned = (SingleSuccedentSequentOnLists)super.clone();
            cloned.left = new FormulaSetOnList[FormulaType.values().length];
            for (int i = 0; i < this.left.length; ++i) {
                if (this.left[i] == null) continue;
                cloned.left[i] = this.left[i].clone();
            }
            cloned.right = this.right;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new ImplementationError("Clone not supported:" + e.getMessage());
        }
    }

    @Override
    public String format() {
        return this.toString();
    }

    public String toString() {
        Object str = "";
        for (int i = 0; i < FormulaType.values().length; ++i) {
            if (this.left[i] == null) continue;
            str = (String)str + this.left[i].toString();
        }
        return (String)str + "==>\n" + (this.right == null ? "" : this.right.toString());
    }
}

