/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula._SingleSuccedentSequent;

public class SingleSuccedentSequentOnBitSet
implements _SingleSuccedentSequent,
Cloneable {
    private FormulaFactory factory;
    private BitSet leftSide;
    private LinkedList<Formula>[] leftFormulas;
    private Formula rightSide;
    private FormulaFactory formulaFactory;

    public SingleSuccedentSequentOnBitSet(FormulaFactory factory) {
        this.formulaFactory = this.formulaFactory;
        this.leftSide = new BitSet(factory.numberOfGeneratedFormulas());
        this.leftFormulas = new LinkedList[FormulaType.values().length];
        this.rightSide = null;
    }

    @Override
    public void addLeft(Formula wff) {
        int idx = wff.getIndex();
        if (!this.leftSide.get(idx)) {
            this.leftSide.set(idx);
            int type_idx = FormulaType.getFormulaType(wff).ordinal();
            if (this.leftFormulas[type_idx] == null) {
                this.leftFormulas[type_idx] = new LinkedList();
            }
            this.leftFormulas[type_idx].add(wff);
        }
    }

    @Override
    public void addRight(Formula wff) {
        this.rightSide = wff;
    }

    public static SingleSuccedentSequentOnBitSet buildArraySequent(FormulaFactory factory, Collection<Formula> leftFormulas, Formula rightFormula) {
        SingleSuccedentSequentOnBitSet seq = new SingleSuccedentSequentOnBitSet(factory);
        if (leftFormulas != null) {
            for (Formula wff : leftFormulas) {
                seq.addLeft(wff);
            }
        }
        seq.addRight(rightFormula);
        return seq;
    }

    @Override
    public SingleSuccedentSequentOnBitSet clone() {
        try {
            SingleSuccedentSequentOnBitSet result = (SingleSuccedentSequentOnBitSet)super.clone();
            result.leftSide = (BitSet)this.leftSide.clone();
            result.leftFormulas = new LinkedList[FormulaType.values().length];
            for (int i = 0; i < this.leftFormulas.length; ++i) {
                if (this.leftFormulas[i] == null) continue;
                result.leftFormulas[i] = (LinkedList)this.leftFormulas[i].clone();
            }
            result.rightSide = this.rightSide;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new ImplementationError(e.getMessage());
        }
    }

    public boolean contains(SingleSuccedentSequentOnBitSet other) {
        if (this.rightSide != other.rightSide) {
            return false;
        }
        int i = other.leftSide.nextSetBit(0);
        while (i >= 0) {
            if (!this.leftSide.get(i)) {
                return false;
            }
            i = other.leftSide.nextSetBit(i + 1);
        }
        return true;
    }

    @Override
    public boolean containsLeft(Formula wff) {
        return this.leftSide.get(wff.getIndex());
    }

    @Override
    public String format() {
        return this.toString();
    }

    @Override
    public Collection<Formula> getAllLeftFormulas() {
        LinkedList<Formula> coll = new LinkedList<Formula>();
        for (LinkedList<Formula> set : this.leftFormulas) {
            if (set == null) continue;
            coll.addAll(set);
        }
        return coll.size() == 0 ? null : coll;
    }

    @Override
    public Collection<Formula> getAllLeftFormulas(FormulaType formulaType) {
        return this.leftFormulas[formulaType.ordinal()];
    }

    @Override
    public Formula getLeft() {
        int idx = this.leftSide.nextSetBit(0);
        if (idx == -1) {
            return null;
        }
        return this.factory.getByIndex(idx);
    }

    @Override
    public Formula getLeft(FormulaType formulaType) {
        LinkedList<Formula> list = this.leftFormulas[formulaType.ordinal()];
        if (list == null) {
            return null;
        }
        return list.getFirst();
    }

    @Override
    public Formula getRight() {
        return this.rightSide;
    }

    @Override
    public Formula getRightFormulaOfType(FormulaType formulaType) {
        if (this.rightSide != null && FormulaType.getFormulaType(this.rightSide) == formulaType) {
            return this.rightSide;
        }
        return null;
    }

    public boolean isContained(SingleSuccedentSequentOnBitSet other) {
        if (this.rightSide != other.rightSide) {
            return false;
        }
        int i = this.leftSide.nextSetBit(0);
        while (i >= 0) {
            if (!other.leftSide.get(i)) {
                return false;
            }
            i = this.leftSide.nextSetBit(i + 1);
        }
        return true;
    }

    @Override
    public boolean isIdentityAxiom() {
        if (this.rightSide == null) {
            return false;
        }
        return this.leftSide.get(this.rightSide.getIndex());
    }

    @Override
    public boolean isFalseInLeftSide() {
        return this.containsLeft(this.formulaFactory.FALSE);
    }

    @Override
    public boolean isRightFormulaTrue() {
        return this.rightSide == null ? false : this.rightSide.isTrue();
    }

    @Override
    public boolean removeLeft(Formula wff) {
        int idx = wff.getIndex();
        if (this.leftSide.get(idx)) {
            this.leftSide.set(idx, false);
            int type_idx = FormulaType.getFormulaType(wff).ordinal();
            LinkedList<Formula> list = this.leftFormulas[type_idx];
            list.remove(wff);
            if (list.size() == 0) {
                this.leftFormulas[type_idx] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRight() {
        if (this.rightSide != null) {
            this.rightSide = null;
            return true;
        }
        return false;
    }

    public String toString() {
        Object str = "";
        for (int i = 0; i < FormulaType.values().length; ++i) {
            if (this.leftFormulas[i] == null) continue;
            str = (String)str + this.leftFormulas[i].toString();
        }
        return (String)str + "==>\n" + (this.rightSide == null ? "" : this.rightSide.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.leftSide == null ? 0 : this.leftSide.hashCode());
        result = 31 * result + (this.rightSide == null ? 0 : this.rightSide.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleSuccedentSequentOnBitSet other = (SingleSuccedentSequentOnBitSet)obj;
        if (this.leftSide == null ? other.leftSide != null : !this.leftSide.equals(other.leftSide)) {
            return false;
        }
        return !(this.rightSide == null ? other.rightSide != null : this.rightSide != other.rightSide);
    }
}

