/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Collection;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula._SingleSuccedentSequent;

public class SingleSuccedentSequentOnBSF
implements _SingleSuccedentSequent,
Cloneable {
    private FormulaFactory formulaFactory;
    private BitSetOfFormulas leftSide;
    private BitSetOfFormulas[] leftFormulas;
    private Formula rightSide;

    public SingleSuccedentSequentOnBSF(FormulaFactory factory) {
        this.formulaFactory = factory;
        this.leftSide = new BitSetOfFormulas(factory);
        this.leftFormulas = new BitSetOfFormulas[FormulaType.values().length];
        this.rightSide = null;
    }

    @Override
    public void addLeft(Formula wff) {
        int idx = wff.getIndex();
        if (!this.leftSide.get(idx)) {
            this.leftSide.set(idx);
            int type_idx = FormulaType.getFormulaType(wff).ordinal();
            if (this.leftFormulas[type_idx] == null) {
                this.leftFormulas[type_idx] = new BitSetOfFormulas(this.formulaFactory);
            }
            this.leftFormulas[type_idx].add(wff);
        }
    }

    public void addLeftAll(BitSetOfFormulas set) {
        for (Formula wff : set) {
            this.addLeft(wff);
        }
    }

    @Override
    public void addRight(Formula wff) {
        this.rightSide = wff;
    }

    public void clearLeft() {
        this.leftSide.clear();
        for (int i = 0; i < this.leftFormulas.length; ++i) {
            this.leftFormulas[i] = null;
        }
    }

    public void clearRight() {
        this.rightSide = null;
    }

    @Override
    public SingleSuccedentSequentOnBSF clone() {
        try {
            SingleSuccedentSequentOnBSF result = (SingleSuccedentSequentOnBSF)super.clone();
            result.formulaFactory = this.formulaFactory;
            result.leftSide = this.leftSide.clone();
            result.rightSide = this.rightSide;
            result.leftFormulas = new BitSetOfFormulas[FormulaType.values().length];
            for (int i = 0; i < this.leftFormulas.length; ++i) {
                if (this.leftFormulas[i] == null) continue;
                result.leftFormulas[i] = this.leftFormulas[i].clone();
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new ImplementationError(e.getMessage());
        }
    }

    @Override
    public boolean containsLeft(Formula wff) {
        return this.leftSide.get(wff.getIndex());
    }

    @Override
    public String format() {
        return this.toString();
    }

    @Override
    public Collection<Formula> getAllLeftFormulas() {
        return this.leftSide.getAllFormulas();
    }

    @Override
    public Collection<Formula> getAllLeftFormulas(FormulaType formulaType) {
        if (this.leftFormulas[formulaType.ordinal()] == null) {
            return null;
        }
        return this.leftFormulas[formulaType.ordinal()].getAllFormulas();
    }

    public FormulaFactory getFormulaFactory() {
        return this.formulaFactory;
    }

    @Override
    public Formula getLeft() {
        return this.leftSide.getFirst();
    }

    @Override
    public Formula getLeft(FormulaType formulaType) {
        if (this.leftFormulas[formulaType.ordinal()] == null) {
            return null;
        }
        return this.leftFormulas[formulaType.ordinal()].getFirst();
    }

    @Override
    public Formula getRight() {
        return this.rightSide;
    }

    @Override
    public Formula getRightFormulaOfType(FormulaType formulaType) {
        if (this.rightSide != null && FormulaType.getFormulaType(this.rightSide) == formulaType) {
            return this.rightSide;
        }
        return null;
    }

    @Override
    public boolean isIdentityAxiom() {
        if (this.rightSide == null) {
            return false;
        }
        return this.leftSide.get(this.rightSide.getIndex());
    }

    @Override
    public boolean isFalseInLeftSide() {
        return this.leftSide.contains(this.formulaFactory.FALSE);
    }

    @Override
    public boolean isRightFormulaTrue() {
        return this.rightSide == null ? false : this.rightSide.isTrue();
    }

    public boolean isLeftSideEmpty() {
        return this.leftSide.cardinality() == 0;
    }

    public BitSetOfFormulas leftSide() {
        return this.leftSide;
    }

    @Override
    public boolean removeLeft(Formula wff) {
        int idx = wff.getIndex();
        if (this.leftSide.get(idx)) {
            this.leftSide.set(idx, false);
            int type_idx = wff.getFormulaType().ordinal();
            BitSetOfFormulas set = this.leftFormulas[type_idx];
            set.remove(wff);
            if (set.cardinality() == 0) {
                this.leftFormulas[type_idx] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRight() {
        if (this.rightSide != null) {
            this.rightSide = null;
            return true;
        }
        return false;
    }

    public String toString() {
        Object str = "";
        Collection<Formula> lf = this.leftSide.getAllFormulas();
        str = (String)str + (lf == null ? "" : lf.toString());
        return (String)str + "==>\n" + (this.rightSide == null ? "" : this.rightSide.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.leftSide == null ? 0 : this.leftSide.hashCode());
        result = 31 * result + (this.rightSide == null ? 0 : this.rightSide.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleSuccedentSequentOnBSF other = (SingleSuccedentSequentOnBSF)obj;
        if (this.leftSide == null ? other.leftSide != null : !this.leftSide.equals(other.leftSide)) {
            return false;
        }
        return !(this.rightSide == null ? other.rightSide != null : !this.rightSide.equals(other.rightSide));
    }
}

