/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Collection;
import java.util.LinkedList;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula._SingleSuccedentSequent;

public class SingleSuccedentSequentOnArray
implements _SingleSuccedentSequent,
Cloneable {
    private static final int ABSENT = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTH = 3;
    private BitSetOfFormulas clashes;
    private int[] sequent;
    private LinkedList<Formula>[] leftFormulas;
    private Formula rightFormula;
    private FormulaFactory formulaFactory;

    public SingleSuccedentSequentOnArray(FormulaFactory factory) {
        this.formulaFactory = factory;
        this.sequent = new int[factory.numberOfGeneratedFormulas()];
        this.leftFormulas = new LinkedList[FormulaType.values().length];
        this.rightFormula = null;
        this.clashes = new BitSetOfFormulas(factory);
    }

    int getArrayLength() {
        return this.sequent.length;
    }

    @Override
    public Collection<Formula> getAllLeftFormulas() {
        LinkedList<Formula> coll = new LinkedList<Formula>();
        for (LinkedList<Formula> set : this.leftFormulas) {
            if (set == null) continue;
            coll.addAll(set);
        }
        return coll.size() == 0 ? null : coll;
    }

    @Override
    public Collection<Formula> getAllLeftFormulas(FormulaType formulaType) {
        return this.leftFormulas[formulaType.ordinal()];
    }

    @Override
    public Formula getRight() {
        return this.rightFormula;
    }

    private void addClashOn(Formula formula) {
        this.clashes.add(formula);
    }

    private void removeClashOn(Formula formula) {
        this.clashes.remove(formula);
    }

    @Override
    public void addLeft(Formula wff) {
        int idx = wff.getIndex();
        if (this.sequent[idx] == 1 || this.sequent[idx] == 3) {
            return;
        }
        if (this.sequent[idx] == 2) {
            this.sequent[idx] = 3;
            this.addClashOn(wff);
        } else {
            this.sequent[idx] = 1;
        }
        this.addToLeftFormulas(wff);
    }

    private void addToLeftFormulas(Formula wff) {
        int idx = FormulaType.getFormulaType(wff).ordinal();
        if (this.leftFormulas[idx] == null) {
            this.leftFormulas[idx] = new LinkedList();
        }
        this.leftFormulas[idx].add(wff);
    }

    private boolean removeFromLeftFormulas(Formula wff) {
        int idx = FormulaType.getFormulaType(wff).ordinal();
        LinkedList<Formula> list = this.leftFormulas[idx];
        boolean result = false;
        if (list != null) {
            result = list.remove(wff);
            if (list.size() == 0) {
                this.leftFormulas[idx] = null;
            }
        }
        return result;
    }

    @Override
    public void addRight(Formula wff) {
        this.removeRight();
        int idx = wff.getIndex();
        if (this.sequent[idx] == 1) {
            this.sequent[idx] = 3;
            this.addClashOn(wff);
        } else {
            this.sequent[idx] = 2;
        }
        this.rightFormula = wff;
    }

    @Override
    public Formula getLeft(FormulaType formulaType) {
        LinkedList<Formula> list = this.leftFormulas[formulaType.ordinal()];
        if (list == null) {
            return null;
        }
        return list.getFirst();
    }

    @Override
    public Formula getLeft() {
        for (LinkedList<Formula> list : this.leftFormulas) {
            if (list == null) continue;
            return list.getFirst();
        }
        return null;
    }

    @Override
    public Formula getRightFormulaOfType(FormulaType formulaType) {
        if (this.rightFormula != null && FormulaType.getFormulaType(this.rightFormula) == formulaType) {
            return this.rightFormula;
        }
        return null;
    }

    @Override
    public boolean removeLeft(Formula wff) {
        int idx = wff.getIndex();
        if (this.sequent[idx] == 3) {
            this.sequent[idx] = 2;
            this.removeClashOn(wff);
        } else {
            this.sequent[idx] = 0;
        }
        return this.removeFromLeftFormulas(wff);
    }

    @Override
    public boolean removeRight() {
        if (this.rightFormula != null) {
            int idx = this.rightFormula.getIndex();
            if (this.sequent[idx] == 3) {
                this.sequent[idx] = 1;
                this.removeClashOn(this.rightFormula);
            } else {
                this.sequent[idx] = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isIdentityAxiom() {
        return !this.clashes.isEmpty();
    }

    @Override
    public boolean isFalseInLeftSide() {
        return this.containsLeft(this.formulaFactory.FALSE);
    }

    @Override
    public boolean isRightFormulaTrue() {
        return this.rightFormula == null ? false : this.rightFormula.isTrue();
    }

    @Override
    public boolean containsLeft(Formula wff) {
        int idx = wff.getIndex();
        return this.sequent[idx] == 1 || this.sequent[idx] == 3;
    }

    @Override
    public SingleSuccedentSequentOnArray clone() {
        try {
            SingleSuccedentSequentOnArray cloned = (SingleSuccedentSequentOnArray)super.clone();
            cloned.clashes = this.clashes.clone();
            cloned.sequent = (int[])this.sequent.clone();
            cloned.leftFormulas = new LinkedList[FormulaType.values().length];
            for (int i = 0; i < cloned.leftFormulas.length; ++i) {
                if (this.leftFormulas[i] == null) continue;
                cloned.leftFormulas[i] = (LinkedList)this.leftFormulas[i].clone();
            }
            cloned.rightFormula = this.rightFormula;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new ImplementationError(e.getMessage());
        }
    }

    @Override
    public String format() {
        return this.toString();
    }

    public String toString() {
        Object str = "";
        for (int i = 0; i < FormulaType.values().length; ++i) {
            if (this.leftFormulas[i] == null) continue;
            str = (String)str + this.leftFormulas[i].toString();
        }
        return (String)str + "==>\n" + (this.rightFormula == null ? "" : this.rightFormula.toString());
    }

    public static SingleSuccedentSequentOnArray buildArraySequent(FormulaFactory factory, Collection<Formula> leftFormulas, Formula rightFormula) {
        SingleSuccedentSequentOnArray seq = new SingleSuccedentSequentOnArray(factory);
        if (leftFormulas != null) {
            for (Formula wff : leftFormulas) {
                seq.addLeft(wff);
            }
        }
        seq.addRight(rightFormula);
        return seq;
    }
}

