/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Stack;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.parser.FormulaBaseListener;
import jtabwbx.prop.parser.FormulaParser;
import jtabwbx.prop.parser.ParsedPropositionalFormula;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

class FromParseTreeFormulaBuilder
extends FormulaBaseListener {
    private Stack<Formula> stack;
    private FormulaFactory formulaFactory;

    public FromParseTreeFormulaBuilder(FormulaFactory formulaFactory) {
        this.formulaFactory = formulaFactory;
    }

    Formula buildFrom(ParsedPropositionalFormula parsedFormula) {
        ParseTree tree = parsedFormula.getParseTree();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk(this, tree);
        if (this.stack.size() == 1) {
            Formula wff = this.stack.pop();
            this.stack = null;
            return wff;
        }
        throw new ImplementationError("Something wrong in parse tree walking.");
    }

    @Override
    public void enterFormula(FormulaParser.FormulaContext ctx) {
        this.stack = new Stack();
    }

    @Override
    public void exitProp(FormulaParser.PropContext ctx) {
        this.stack.push(this.formulaFactory.buildAtomic(ctx.getText()));
    }

    @Override
    public void exitAnd(FormulaParser.AndContext ctx) {
        Formula right = this.stack.pop();
        Formula left = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(PropositionalConnective.AND, left, right));
    }

    @Override
    public void exitOr(FormulaParser.OrContext ctx) {
        Formula right = this.stack.pop();
        Formula left = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(PropositionalConnective.OR, left, right));
    }

    @Override
    public void exitImp(FormulaParser.ImpContext ctx) {
        Formula right = this.stack.pop();
        Formula left = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(PropositionalConnective.IMPLIES, left, right));
    }

    @Override
    public void exitEq(FormulaParser.EqContext ctx) {
        Formula right = this.stack.pop();
        Formula left = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(PropositionalConnective.EQ, left, right));
    }

    @Override
    public void exitNeg(FormulaParser.NegContext ctx) {
        Formula subf = this.stack.pop();
        this.stack.push(this.formulaFactory.buildCompound(PropositionalConnective.NOT, subf));
    }

    @Override
    public void exitPar(FormulaParser.ParContext ctx) {
    }
}

