/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.AbstractCompoundFormula;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.FormulaProposition;
import jtabwbx.prop.formula.PropositionalSubstitution;
import jtabwbx.prop.formula.Substitution;

final class FormulaNot
extends AbstractCompoundFormula {
    private static Formula NullFormula = new Formula(){

        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public Formula calculateBooleanSimplification() {
            return this;
        }

        @Override
        public Formula applySubstitution(PropositionalSubstitution subst) {
            return this;
        }

        @Override
        public Formula applySubstitution(Substitution subst) {
            return this;
        }

        @Override
        public Formula applyIntuitionisticPartialSubstitution(Substitution subst) {
            return this;
        }

        @Override
        public boolean containsTrue() {
            return false;
        }

        @Override
        public boolean containsFalse() {
            return false;
        }

        @Override
        public boolean isIntuitionisticLocalFormula() {
            return false;
        }

        @Override
        public boolean containsProposition(FormulaProposition name) {
            return false;
        }

        @Override
        public boolean isAtomic() {
            return false;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public FormulaType getFormulaType() {
            return null;
        }

        @Override
        public PropositionalConnective mainConnective() {
            return null;
        }

        @Override
        public Formula[] immediateSubformulas() {
            return null;
        }

        @Override
        public String shortName() {
            return "NullFormula";
        }

        @Override
        public Formula replacePropVarWithTrue(BitSetOfFormulas propVariables) {
            return this;
        }

        @Override
        public String format() {
            return this.toString();
        }

        public String toString() {
            return "NullFormula, used to unify unary and binary formulae methods";
        }

        @Override
        public boolean isFalse() {
            return false;
        }

        @Override
        public boolean isTrue() {
            return false;
        }

        @Override
        public FormulaFactory getFactory() {
            return null;
        }
    };

    protected FormulaNot(FormulaFactory formulaFactory, Formula subFormula) {
        super(formulaFactory, PropositionalConnective.NOT, new Formula[]{subFormula}, subFormula, NullFormula);
    }

    @Override
    protected int computeHashCode(Formula[] subFormulas) {
        int result = this.mainConnective().hashCode();
        result = 31 * result + this.left.hashCode();
        result = 31 * result + 1;
        return result;
    }

    @Override
    protected Formula computeBooleanSimplification() {
        Formula newSub = this.left.calculateBooleanSimplification();
        if (newSub.isTrue()) {
            return this.formulaFactory.getFalse();
        }
        if (newSub.isFalse()) {
            return this.formulaFactory.getTrue();
        }
        return this.formulaFactory.buildCompound(this.mainConnective(), newSub);
    }

    @Override
    public String toString() {
        Object subf = "";
        subf = this.left.isAtomic() ? this.left.toString() : (this.left.mainConnective() != PropositionalConnective.NOT ? "(" + this.left.toString() + ")" : this.left.toString());
        if (Formula.INSERT_INDEX_IN_TO_STRING_RESULT) {
            return this.mainConnective().toString() + (String)subf + "<" + this.getIndex() + ">";
        }
        return this.mainConnective().toString() + (String)subf;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.left == ((FormulaNot)o).left;
    }

    @Override
    protected Formula computePartialSubstitution(Substitution subst) {
        return this;
    }

    @Override
    public FormulaType getFormulaType() {
        return FormulaType.NOT_WFF;
    }
}

