/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Collection;
import java.util.HashMap;
import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaProposition;

public class FormulaLatexFormatter {
    private boolean abbreviateImpliesFalse = true;
    private HashMap<Formula, String> formulaAbbreviations;
    private String MACRO_TRUE = "\\top";
    private String MACRO_FALSE = "\\bot";
    private String MACRO_AND = "\\land";
    private String MACRO_OR = "\\lor";
    private String MACRO_IMPLIES = "\\to";
    private String MACRO_NOT = "\\neg";
    private String MACRO_EQ = "\\leftrightarrow";
    private static String[][] replacement = new String[][]{{"_", "\\\\_"}, {"\\$", "\\$"}};

    public void setFormulaAbbreviations(HashMap<Formula, String> formulaAbbreviations) {
        this.formulaAbbreviations = formulaAbbreviations;
    }

    public String toLatex(Formula[] formulas, String separator) {
        Object str = "";
        if (formulas == null) {
            return "";
        }
        for (int i = 0; i < formulas.length; ++i) {
            str = (String)str + this.toLatex(formulas[i]) + (i < formulas.length - 1 ? separator : "");
        }
        return str;
    }

    public String toLatex(boolean applyAbbreviations, Formula[] formulas, String separator) {
        Object str = "";
        if (formulas == null) {
            return "";
        }
        for (int i = 0; i < formulas.length; ++i) {
            str = (String)str + this.toLatex(applyAbbreviations, formulas[i]) + (i < formulas.length - 1 ? separator : "");
        }
        return str;
    }

    public String toLatex(Collection<Formula> formulas, String separator) {
        if (formulas == null || formulas.size() == 0) {
            return "";
        }
        return this.toLatex(formulas.toArray(new Formula[formulas.size()]), separator);
    }

    public String toLatex(boolean applyAbbreviations, Collection<Formula> formulas, String separator) {
        if (formulas == null || formulas.size() == 0) {
            return "";
        }
        return this.toLatex(applyAbbreviations, formulas.toArray(new Formula[formulas.size()]), separator);
    }

    public String toLatex(Formula wff) {
        return this._toLatex(wff, false);
    }

    public String toLatex(boolean applyApplreviations, Formula wff) {
        if (!applyApplreviations || this.formulaAbbreviations == null) {
            return this._toLatex(wff, false);
        }
        return this._toLatexWithAbbreviations(wff, false);
    }

    public void setCommandFor(PropositionalConnective propositionalConnective, String latexCmd) {
        switch (propositionalConnective) {
            case AND: {
                this.MACRO_AND = latexCmd;
                break;
            }
            case OR: {
                this.MACRO_OR = latexCmd;
                break;
            }
            case IMPLIES: {
                this.MACRO_IMPLIES = latexCmd;
                break;
            }
            case NOT: {
                this.MACRO_NOT = latexCmd;
                break;
            }
            case EQ: {
                this.MACRO_EQ = latexCmd;
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED_arg, propositionalConnective.name());
            }
        }
    }

    public void setCommandForTRUE(String latexCmd) {
        this.MACRO_TRUE = latexCmd;
    }

    public void setCommandForFALSE(String latexCmd) {
        this.MACRO_FALSE = latexCmd;
    }

    private String _toLatex(Formula wff, boolean parenthesize) {
        Object wffStr;
        if (wff.isAtomic()) {
            parenthesize = false;
            FormulaProposition prop = (FormulaProposition)wff;
            if (prop.isFalse()) {
                return this.MACRO_FALSE + " ";
            }
            if (prop.isTrue()) {
                return this.MACRO_TRUE + " ";
            }
            return FormulaLatexFormatter.correctName(wff.format());
        }
        Formula[] subwffs = wff.immediateSubformulas();
        switch (wff.mainConnective()) {
            case AND: {
                wffStr = this.buildBinary(subwffs, this.MACRO_AND);
                break;
            }
            case OR: {
                wffStr = this.buildBinary(subwffs, this.MACRO_OR);
                break;
            }
            case NOT: {
                wffStr = this.MACRO_NOT + " " + this._toLatex(subwffs[0], true);
                parenthesize = false;
                break;
            }
            case IMPLIES: {
                if (this.abbreviateImpliesFalse && subwffs[1].isFalse()) {
                    wffStr = this.MACRO_NOT + " " + this._toLatex(subwffs[0], true);
                    parenthesize = false;
                    break;
                }
                wffStr = this.buildBinary(subwffs, this.MACRO_IMPLIES);
                break;
            }
            case EQ: {
                wffStr = this.buildBinary(subwffs, this.MACRO_EQ);
                break;
            }
            default: {
                throw new CaseNotImplementedImplementationError(wff.mainConnective().getName());
            }
        }
        if (parenthesize) {
            return "(" + (String)wffStr + ")";
        }
        return wffStr;
    }

    private String _toLatexWithAbbreviations(Formula wff, boolean parenthesize) {
        Object wffStr;
        String abbreviation = this.formulaAbbreviations.get(wff);
        if (abbreviation != null) {
            return abbreviation;
        }
        if (wff.isAtomic()) {
            parenthesize = false;
            FormulaProposition prop = (FormulaProposition)wff;
            if (prop.isFalse()) {
                return this.MACRO_FALSE + " ";
            }
            if (prop.isTrue()) {
                return this.MACRO_TRUE + " ";
            }
            return FormulaLatexFormatter.correctName(wff.format());
        }
        Formula[] subwffs = wff.immediateSubformulas();
        switch (wff.mainConnective()) {
            case AND: {
                wffStr = this.buildBinaryWithAbbreviations(subwffs, this.MACRO_AND);
                break;
            }
            case OR: {
                wffStr = this.buildBinaryWithAbbreviations(subwffs, this.MACRO_OR);
                break;
            }
            case NOT: {
                wffStr = this.MACRO_NOT + " " + this._toLatexWithAbbreviations(subwffs[0], true);
                parenthesize = false;
                break;
            }
            case IMPLIES: {
                if (this.abbreviateImpliesFalse && subwffs[1].isFalse()) {
                    wffStr = this.MACRO_NOT + " " + this._toLatexWithAbbreviations(subwffs[0], true);
                    parenthesize = false;
                    break;
                }
                wffStr = this.buildBinaryWithAbbreviations(subwffs, this.MACRO_IMPLIES);
                break;
            }
            case EQ: {
                wffStr = this.buildBinaryWithAbbreviations(subwffs, this.MACRO_EQ);
                break;
            }
            default: {
                throw new CaseNotImplementedImplementationError(wff.mainConnective().getName());
            }
        }
        if (parenthesize) {
            return "(" + (String)wffStr + ")";
        }
        return wffStr;
    }

    private String buildBinary(Formula[] subwffs, String connective) {
        Object str = "";
        for (int i = 0; i < subwffs.length; ++i) {
            str = (String)str + this._toLatex(subwffs[i], true) + (String)(i < subwffs.length - 1 ? connective + " " : " ");
        }
        return str;
    }

    private String buildBinaryWithAbbreviations(Formula[] subwffs, String connective) {
        Object str = "";
        for (int i = 0; i < subwffs.length; ++i) {
            str = (String)str + this._toLatexWithAbbreviations(subwffs[i], true) + (String)(i < subwffs.length - 1 ? connective + " " : " ");
        }
        return str;
    }

    private static String correctName(String name) {
        String result = name;
        for (int i = 0; i < replacement.length; ++i) {
            result = result.replaceAll(replacement[i][0], replacement[i][1]);
        }
        return result;
    }

    public boolean isAbbreviateImpliesFalse() {
        return this.abbreviateImpliesFalse;
    }

    public void setAbbreviateImpliesFalse(boolean abbreviateImpliesFalse) {
        this.abbreviateImpliesFalse = abbreviateImpliesFalse;
    }
}

