/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.AbstractCompoundFormula;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.Substitution;

final class FormulaIff
extends AbstractCompoundFormula {
    protected FormulaIff(FormulaFactory formulaFactory, Formula left, Formula right) {
        super(formulaFactory, PropositionalConnective.EQ, new Formula[]{left, right}, left, right);
    }

    @Override
    protected Formula computeBooleanSimplification() {
        Formula newRight;
        Formula newLeft = this.left.calculateBooleanSimplification();
        if (newLeft == (newRight = this.right.calculateBooleanSimplification())) {
            return this.formulaFactory.getTrue();
        }
        if (newLeft.isFalse() && newRight.isTrue()) {
            return this.formulaFactory.getFalse();
        }
        if (newLeft.isTrue() && newRight.isFalse()) {
            return this.formulaFactory.getFalse();
        }
        if (newLeft.isTrue()) {
            return newRight;
        }
        if (newRight.isTrue()) {
            return newLeft;
        }
        return this.formulaFactory.buildCompound(this.mainConnective(), newLeft, newRight);
    }

    @Override
    protected Formula computePartialSubstitution(Substitution subst) {
        return this;
    }

    @Override
    public FormulaType getFormulaType() {
        return FormulaType.EQ_WFF;
    }
}

