/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.HashSet;
import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.FormulaProposition;
import jtabwbx.prop.formula.PropositionalSubstitution;
import jtabwbx.prop.formula.Substitution;

abstract class AbstractCompoundFormula
extends Formula {
    private HashSet<FormulaProposition> propositions;
    private HashSet<Formula> formulae;
    private Formula booleanSimplifiedVersion;
    private final int hash;
    private boolean isLocal;
    private PropositionalConnective mainConnective;
    protected final FormulaFactory formulaFactory;
    protected final Formula[] subFormulas;
    protected final Formula left;
    protected final Formula right;

    protected AbstractCompoundFormula(FormulaFactory formulaFactory, PropositionalConnective mainConnective, Formula[] subFormulas, Formula left, Formula right) {
        this.formulaFactory = formulaFactory;
        this.mainConnective = mainConnective;
        this.subFormulas = subFormulas;
        this.left = left;
        this.right = right;
        this.propositions = null;
        this.booleanSimplifiedVersion = null;
        this.hash = this.computeHashCode(subFormulas);
        switch (mainConnective) {
            case AND: {
                this.isLocal = left.isIntuitionisticLocalFormula() || right.isIntuitionisticLocalFormula();
                this.size = left.size + right.size + 1;
                break;
            }
            case OR: {
                this.isLocal = left.isIntuitionisticLocalFormula() && right.isIntuitionisticLocalFormula();
                this.size = left.size + right.size + 1;
                break;
            }
            case IMPLIES: 
            case EQ: {
                this.isLocal = false;
                this.size = left.size + right.size + 1;
                break;
            }
            case NOT: {
                this.isLocal = false;
                this.size = left.size + 1;
                break;
            }
            default: {
                throw new CaseNotImplementedImplementationError(mainConnective.toString());
            }
        }
    }

    @Override
    public final FormulaFactory getFactory() {
        return this.formulaFactory;
    }

    @Override
    public PropositionalConnective mainConnective() {
        return this.mainConnective;
    }

    @Override
    public String shortName() {
        return this.mainConnective.getName() + "-formula";
    }

    private void updateHashSetsIfNeeded() {
        if (this.propositions == null) {
            this.propositions = new HashSet();
            this.formulae = new HashSet();
            for (Formula sub : this.subFormulas) {
                if (sub instanceof FormulaProposition) {
                    FormulaProposition f = (FormulaProposition)sub;
                    this.propositions.add(f);
                    continue;
                }
                AbstractCompoundFormula subCompound = (AbstractCompoundFormula)sub;
                subCompound.updateHashSetsIfNeeded();
                this.propositions.addAll(subCompound.propositions);
                this.formulae.add(subCompound);
                this.formulae.addAll(subCompound.formulae);
            }
        }
    }

    @Override
    public Formula[] immediateSubformulas() {
        return this.subFormulas;
    }

    @Override
    public final boolean isAtomic() {
        return false;
    }

    @Override
    public final boolean isCompound() {
        return true;
    }

    @Override
    public final boolean isFalse() {
        return false;
    }

    @Override
    public final boolean isTrue() {
        return false;
    }

    @Override
    public final boolean isIntuitionisticLocalFormula() {
        return this.isLocal;
    }

    @Override
    public final int hashCode() {
        return this.hash;
    }

    private boolean containSubFormula(Substitution subst) {
        this.updateHashSetsIfNeeded();
        boolean contain = false;
        for (Formula key : subst.keySet()) {
            contain = contain || this.formulae.contains(key) || this.propositions.contains(key);
        }
        return contain;
    }

    private boolean containProposition(PropositionalSubstitution subst) {
        this.updateHashSetsIfNeeded();
        boolean contain = false;
        for (FormulaProposition key : subst.keySet()) {
            contain = contain || this.propositions.contains(key);
        }
        return contain;
    }

    private boolean containProposition(BitSetOfFormulas propVariables) {
        this.updateHashSetsIfNeeded();
        for (Formula key : propVariables) {
            if (!this.propositions.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean containsProposition(FormulaProposition proposition) {
        this.updateHashSetsIfNeeded();
        return this.propositions.contains(proposition);
    }

    @Override
    public final boolean containsTrue() {
        return this.containsProposition(this.formulaFactory.getTrue());
    }

    @Override
    public final boolean containsFalse() {
        return this.containsProposition(this.formulaFactory.getFalse());
    }

    @Override
    public final Formula calculateBooleanSimplification() {
        if (this.booleanSimplifiedVersion != null) {
            return this.booleanSimplifiedVersion;
        }
        this.updateHashSetsIfNeeded();
        this.booleanSimplifiedVersion = !this.propositions.contains(this.formulaFactory.getTrue()) && !this.propositions.contains(this.formulaFactory.getFalse()) ? this : this.computeBooleanSimplification();
        return this.booleanSimplifiedVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCompoundFormula that = (AbstractCompoundFormula)o;
        boolean pair = this.left == that.left && this.right == that.right;
        return pair || this.left == that.right && this.right == that.left;
    }

    @Override
    public final Formula applySubstitution(Substitution subst) {
        Formula newF = (Formula)subst.get(this);
        if (newF != null) {
            return newF;
        }
        if (!this.containSubFormula(subst)) {
            return this;
        }
        newF = this.formulaFactory.buildCompound(this.mainConnective(), this.left.applySubstitution(subst), this.right.applySubstitution(subst));
        return newF;
    }

    @Override
    public final Formula applySubstitution(PropositionalSubstitution subst) {
        if (!this.containProposition(subst)) {
            return this;
        }
        Formula newF = this.formulaFactory.buildCompound(this.mainConnective(), this.left.applySubstitution(subst), this.right.applySubstitution(subst));
        return newF;
    }

    @Override
    public final Formula replacePropVarWithTrue(BitSetOfFormulas propVariables) {
        if (!this.containProposition(propVariables)) {
            return this;
        }
        Formula newF = this.formulaFactory.buildCompound(this.mainConnective(), this.left.replacePropVarWithTrue(propVariables), this.right.replacePropVarWithTrue(propVariables));
        return newF;
    }

    @Override
    public final Formula applyIntuitionisticPartialSubstitution(Substitution subst) {
        Formula newF = (Formula)subst.get(this);
        if (newF != null) {
            return newF;
        }
        newF = this.computePartialSubstitution(subst);
        return newF;
    }

    @Override
    public String format() {
        return this.toString();
    }

    public String toString() {
        String formula = null;
        formula = this.formulaFactory.isFormatImpliesFalseAsNegation() && this.right.isFalse() ? PropositionalConnective.NOT.toString() + this.left.toString() : "(" + this.left.toString() + " " + this.mainConnective().toString() + " " + this.right.toString() + ")";
        if (Formula.INSERT_INDEX_IN_TO_STRING_RESULT) {
            return formula + "<" + this.getIndex() + ">";
        }
        return formula;
    }

    protected int computeHashCode(Formula[] subFormulas) {
        int result = this.mainConnective().hashCode();
        int leftHash = this.subFormulas[0].hashCode();
        int rightHash = this.subFormulas[1].hashCode();
        result = 31 * result + Math.min(leftHash, rightHash);
        result = 31 * result + Math.max(leftHash, rightHash);
        return result;
    }

    abstract Formula computeBooleanSimplification();

    protected abstract Formula computePartialSubstitution(Substitution var1);
}

