/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.btformula;

import java.util.Stack;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.btformula.BTFormula;
import jtabwbx.prop.btformula.BTPropositionalFormulaFactory;
import jtabwbx.prop.btformula.ImplementationError;
import jtabwbx.prop.parser.FormulaBaseListener;
import jtabwbx.prop.parser.FormulaParser;
import jtabwbx.prop.parser.ParsedPropositionalFormula;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

class FromParseTreeBTFormulaBuilder
extends FormulaBaseListener {
    private Stack<BTFormula> stack;
    private BTPropositionalFormulaFactory factory;

    public FromParseTreeBTFormulaBuilder(BTPropositionalFormulaFactory factory) {
        this.factory = factory;
    }

    BTFormula buildFrom(ParsedPropositionalFormula parsedFormula) {
        ParseTree tree = parsedFormula.getParseTree();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk(this, tree);
        if (this.stack.size() == 1) {
            BTFormula wff = this.stack.pop();
            this.stack = null;
            return wff;
        }
        throw new ImplementationError();
    }

    @Override
    public void enterFormula(FormulaParser.FormulaContext ctx) {
        this.stack = new Stack();
    }

    @Override
    public void exitProp(FormulaParser.PropContext ctx) {
        this.stack.push(this.factory.buildAtomic(ctx.getText()));
    }

    @Override
    public void exitAnd(FormulaParser.AndContext ctx) {
        BTFormula right = this.stack.pop();
        BTFormula left = this.stack.pop();
        this.stack.push(this.factory.buildCompound(PropositionalConnective.AND, left, right));
    }

    @Override
    public void exitOr(FormulaParser.OrContext ctx) {
        BTFormula right = this.stack.pop();
        BTFormula left = this.stack.pop();
        this.stack.push(this.factory.buildCompound(PropositionalConnective.OR, left, right));
    }

    @Override
    public void exitImp(FormulaParser.ImpContext ctx) {
        BTFormula right = this.stack.pop();
        BTFormula left = this.stack.pop();
        this.stack.push(this.factory.buildCompound(PropositionalConnective.IMPLIES, left, right));
    }

    @Override
    public void exitEq(FormulaParser.EqContext ctx) {
        BTFormula right = this.stack.pop();
        BTFormula left = this.stack.pop();
        this.stack.push(this.factory.buildCompound(PropositionalConnective.EQ, left, right));
    }

    @Override
    public void exitNeg(FormulaParser.NegContext ctx) {
        this.stack.push(this.factory.buildCompound(PropositionalConnective.NOT, this.stack.pop()));
    }

    @Override
    public void exitPar(FormulaParser.ParContext ctx) {
    }
}

