/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.btformula;

import java.util.Arrays;
import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.btformula.BTFormula;

public class BTFormulaCompound
extends BTFormula {
    protected PropositionalConnective mainConnective;
    protected BTFormula[] subformulas;

    public BTFormulaCompound(PropositionalConnective mainConnective, BTFormula left, BTFormula right) {
        this.subformulas = new BTFormula[]{left, right};
        this.mainConnective = mainConnective;
    }

    public BTFormulaCompound(PropositionalConnective mainConnective, BTFormula subformula) {
        this.subformulas = new BTFormula[]{subformula};
        this.mainConnective = mainConnective;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.mainConnective == ((BTFormulaCompound)obj).mainConnective && Arrays.equals(this.subformulas, ((BTFormulaCompound)obj).subformulas);
    }

    @Override
    public BTFormula[] immediateSubformulas() {
        return this.subformulas;
    }

    @Override
    public PropositionalConnective mainConnective() {
        return this.mainConnective;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public String shortName() {
        return this.mainConnective.getName() + "-formula";
    }

    @Override
    public String format() {
        return this.toString();
    }

    public String toString() {
        switch (this.mainConnective) {
            case NOT: {
                BTFormula left = this.subformulas[0];
                Object subf = "";
                if (left.isAtomic()) {
                    subf = left.toString();
                } else {
                    switch (left.mainConnective()) {
                        case NOT: {
                            subf = "(" + left.toString() + ")";
                            break;
                        }
                        default: {
                            subf = left.toString();
                        }
                    }
                }
                return this.mainConnective().toString() + (String)subf;
            }
            case AND: 
            case OR: 
            case EQ: 
            case IMPLIES: {
                int i;
                Object str = "";
                BTFormula[] subformulas = this.immediateSubformulas();
                String[] subformulasString = new String[subformulas.length];
                for (i = 0; i < subformulasString.length; ++i) {
                    subformulasString[i] = subformulas[i].toString();
                }
                for (i = 0; i < subformulasString.length; ++i) {
                    str = (String)str + subformulasString[i] + (String)(i < subformulasString.length - 1 ? " " + this.mainConnective.toString() + " " : "");
                }
                return "(" + (String)str + ")";
            }
        }
        throw new CaseNotImplementedImplementationError(this.mainConnective.getName());
    }
}

