/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.problems;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.launcher._ProblemReader;
import jtabwbx.problems.JTWProblemLexer;
import jtabwbx.problems.JTWProblemParser;
import jtabwbx.problems.JTabWbProblemBuilder;
import jtabwbx.problems.JTabWbSimpleProblem;
import jtabwbx.problems.ProblemDescriptionException;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class JTabWbSimpleProblemReader
implements _ProblemReader {
    public static final String NAME = "jtawb_format";
    private static final String DESCRIPTION = "The file describes a problem according with simple JTabWb format";
    private final String PRE_NAME = "% File     :";
    private final String PRE_STATUS = "% Status   :";
    private String problemSource = null;

    public JTabWbSimpleProblemReader() {
    }

    public JTabWbSimpleProblemReader(String source) {
        this.problemSource = source;
    }

    @Override
    public JTabWbSimpleProblem read(Reader input) throws ProblemDescriptionException, IOException {
        String problemName = null;
        ProvabilityStatus problemStatus = null;
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(input);
            String line = reader.readLine();
            sb.append(line + "\n");
            line = reader.readLine();
            sb.append(line + "\n");
            problemName = line.substring("% File     :".length()).trim();
            line = reader.readLine();
            sb.append(line + "\n");
            String strStatus = line.substring("% Status   :".length()).trim();
            problemStatus = strStatus.equals("provable") ? ProvabilityStatus.PROVABLE : (strStatus.equals("unprovable") ? ProvabilityStatus.UNPROVABLE : ProvabilityStatus.UNKNOWN);
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (NullPointerException e) {
            throw new ProblemDescriptionException("the problem is not in the JTabWb format.");
        }
        JTWProblemLexer lexer = new JTWProblemLexer(new ANTLRInputStream(sb.toString()));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JTWProblemParser parser = new JTWProblemParser(tokens);
        JTWProblemParser.ProblemContext tree = parser.problem();
        if (parser.getNumberOfSyntaxErrors() > 0) {
            throw new ProblemDescriptionException("parsing error.");
        }
        JTabWbProblemBuilder pb = new JTabWbProblemBuilder();
        ParseTreeWalker ptw = new ParseTreeWalker();
        ptw.walk(pb, tree);
        JTabWbSimpleProblem problem = new JTabWbSimpleProblem(problemName, this.problemSource);
        problem.setProblemStatus(problemStatus);
        JTabWbSimpleProblem.Definition[] definitions = pb.getDefinitions();
        if (definitions == null) {
            problem.addConjecture(pb.getProblemFormula());
        } else {
            problem.setDefinitions(pb.getDefinitions());
            problem.setFormulaSpecification(pb.getProblemFormula());
            problem.setFormulaFromSpecification();
        }
        return problem;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

