/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.problems;

import java.util.HashMap;
import jtabwbx.problems.ProblemDescription;

public class JTabWbSimpleProblem
extends ProblemDescription {
    public static String ROLE_CONJECTURE = "conjecture";
    private Definition[] definitions;
    private String formulaSpecification;

    public JTabWbSimpleProblem(String name, String inputSource) {
        super(name, inputSource);
    }

    public JTabWbSimpleProblem(String name) {
        super(name);
    }

    public JTabWbSimpleProblem() {
    }

    public Definition[] getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Definition[] definitions) {
        int i;
        this.definitions = definitions;
        HashMap<String, String> defined = new HashMap<String, String>();
        for (i = 0; i < definitions.length; ++i) {
            if (defined.containsKey(definitions[i].name)) {
                throw new RuntimeException("Name [" + definitions[i].name + "] already defined");
            }
            defined.put(definitions[i].name, definitions[i].abbreviation);
        }
        for (i = 0; i < definitions.length; ++i) {
            String formulaStr = definitions[i].abbreviation;
            for (int j = 0; j < i; ++j) {
                formulaStr = formulaStr.replaceAll(definitions[j].name, "(" + definitions[j].formula + ")");
            }
            definitions[i].formula = formulaStr;
        }
    }

    public void addConjecture(String wff) {
        super.add(ROLE_CONJECTURE, wff);
    }

    public String getConjecture() {
        return super.getFormulasByRole(ROLE_CONJECTURE).getFirst();
    }

    public String getFormulaSpecification() {
        return this.formulaSpecification;
    }

    public void setFormulaSpecification(String formulaSpecification) {
        this.formulaSpecification = formulaSpecification;
    }

    public void setFormulaFromSpecification() {
        if (this.formulaSpecification == null) {
            throw new RuntimeException("No formula specification has been defined!");
        }
        if (this.definitions == null) {
            throw new RuntimeException("No definition have been defined!");
        }
        String formula = this.formulaSpecification;
        for (int i = this.definitions.length - 1; i >= 0; --i) {
            formula = formula.replaceAll(this.definitions[i].getName(), "(" + this.definitions[i].getFormula() + ")");
        }
        this.addConjecture(formula);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Problem source: " + (this.getSource() == null ? "<null>" : this.getSource()) + "\n");
        sb.append("Problem name: " + this.getProblemName() + "\n");
        sb.append("Problem status: " + this.getProblemStatus().name() + "\n");
        sb.append("Formula spec.: " + (this.formulaSpecification == null ? "<null>" : this.formulaSpecification) + "\n");
        sb.append("Definitions: ");
        if (this.definitions == null) {
            sb.append("<null>\n");
        } else {
            sb.append("{\n");
            for (Definition def : this.definitions) {
                sb.append("  " + def.getName() + " = " + def.getFormula() + ";\n");
            }
            sb.append("}\n");
        }
        sb.append("Formula: " + this.getFormulasByRole(ROLE_CONJECTURE).getFirst());
        return sb.toString();
    }

    public static class Definition {
        private String name;
        private String formula;
        private String abbreviation;

        public Definition(String name, String abbreviation) {
            this.name = name;
            this.abbreviation = abbreviation;
        }

        public String getName() {
            return this.name;
        }

        public String getFormula() {
            return this.formula;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String toString() {
            return "Definition [name=" + this.name + ", formula=" + this.formula + ", abbreviation=" + this.abbreviation + "]";
        }
    }
}

