/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.problems;

import java.util.ArrayList;
import java.util.LinkedList;
import jtabwbx.problems.JTWProblemBaseListener;
import jtabwbx.problems.JTWProblemParser;
import jtabwbx.problems.JTabWbProblemParsingException;
import jtabwbx.problems.JTabWbSimpleProblem;

public class JTabWbProblemBuilder
extends JTWProblemBaseListener {
    private ArrayList<JTabWbSimpleProblem.Definition> definitions;
    private String problemFormula;
    private LinkedList<JTWProblemParser.PropContext> lastWffAtoms;

    @Override
    public void enterDefinitions(JTWProblemParser.DefinitionsContext ctx) {
        this.definitions = new ArrayList();
    }

    @Override
    public void exitDefinitions(JTWProblemParser.DefinitionsContext ctx) {
        if (this.definitions.size() == 0) {
            this.definitions = null;
        }
    }

    @Override
    public void exitDefinition(JTWProblemParser.DefinitionContext ctx) {
        String name = ctx.ID().getText();
        String defFormula = ctx.formula().getText();
        for (JTWProblemParser.PropContext atomCtx : this.lastWffAtoms) {
            if (!atomCtx.ID().getText().equals(name)) continue;
            throw new JTabWbProblemParsingException("Recursive definitions are not allowed");
        }
        this.definitions.add(new JTabWbSimpleProblem.Definition(name, defFormula));
    }

    @Override
    public void enterFormula(JTWProblemParser.FormulaContext ctx) {
        this.lastWffAtoms = new LinkedList();
    }

    @Override
    public void exitFormula(JTWProblemParser.FormulaContext ctx) {
        this.problemFormula = ctx.wff().getText();
    }

    @Override
    public void exitProp(JTWProblemParser.PropContext ctx) {
        this.lastWffAtoms.add(ctx);
    }

    public JTabWbSimpleProblem.Definition[] getDefinitions() {
        if (this.definitions == null) {
            return null;
        }
        return this.definitions.toArray(new JTabWbSimpleProblem.Definition[this.definitions.size()]);
    }

    public String getProblemFormula() {
        return this.problemFormula;
    }
}

