/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.problems;

import java.util.HashMap;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwbx.problems.ILTPProblem;
import jtabwbx.problems.ILTProblemParser;
import jtabwbx.problems.ProblemDescriptionException;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;

class ILTPProblemBuilder {
    private FormulaFactory formulaFactory;
    private String problemSource;
    private String problemName;
    private ProvabilityStatus problemStatus;
    private HashMap<String, Formula> axioms = new HashMap();
    private HashMap<String, Formula> conjectures = new HashMap();

    public ILTPProblemBuilder() {
        this.formulaFactory = new FormulaFactory();
    }

    ILTPProblem build() throws ProblemDescriptionException {
        ILTPProblem pd = new ILTPProblem(this.problemName, this.problemSource);
        pd.setProblemStatus(this.problemStatus);
        if (!this.axioms.isEmpty()) {
            for (Formula formula : this.axioms.values()) {
                pd.addAxiom(formula.format());
            }
        }
        Formula conjecture = null;
        if (this.conjectures.isEmpty()) {
            throw new ProblemDescriptionException("No conjecture is specified");
        }
        if (this.conjectures.size() > 1) {
            throw new ProblemDescriptionException("More than one conjecture is specified");
        }
        conjecture = this.conjectures.values().toArray(new Formula[1])[0];
        pd.addConjecture(conjecture.format());
        return pd;
    }

    public void addFormula(ILTProblemParser.Terminal formulaRole, String name, Formula formula) {
        switch (formulaRole) {
            case KEY_AXIOM: {
                this.axioms.put(name, formula);
                break;
            }
            case KEY_CONJECTURE: {
                this.conjectures.put(name, formula);
                break;
            }
            default: {
                throw new CaseNotImplementedImplementationError(formulaRole.name());
            }
        }
    }

    public Formula buildAtomic(String name) {
        return this.formulaFactory.buildAtomic(name);
    }

    public Formula buildUnary(ILTProblemParser.Terminal operator, Formula subf) {
        PropositionalConnective mainConnective = null;
        switch (operator) {
            case OP_NOT: {
                mainConnective = PropositionalConnective.NOT;
                break;
            }
            default: {
                throw new CaseNotImplementedImplementationError(operator.name());
            }
        }
        Formula formula = this.formulaFactory.buildCompound(mainConnective, subf);
        return formula;
    }

    public Formula buildBinary(ILTProblemParser.Terminal operator, Formula subf1, Formula subf2) {
        PropositionalConnective mainConnective = null;
        switch (operator) {
            case OP_AND: {
                mainConnective = PropositionalConnective.AND;
                break;
            }
            case OP_OR: {
                mainConnective = PropositionalConnective.OR;
                break;
            }
            case OP_IMPLIES: {
                mainConnective = PropositionalConnective.IMPLIES;
                break;
            }
            case OP_EQ: {
                mainConnective = PropositionalConnective.EQ;
                break;
            }
            default: {
                throw new CaseNotImplementedImplementationError(operator.name());
            }
        }
        Formula formula = this.formulaFactory.buildCompound(mainConnective, subf1, subf2);
        return formula;
    }

    public void setFormulaFactory(FormulaFactory formulaFactory) {
        this.formulaFactory = formulaFactory;
    }

    public void setProblemSource(String problemSource) {
        this.problemSource = problemSource;
    }

    public void setProblemName(String problemName) {
        this.problemName = problemName;
    }

    public void setProblemStatus(ProvabilityStatus problemStatus) {
        this.problemStatus = problemStatus;
    }

    public void setProblemStatus(String problemStatus) throws ProblemDescriptionException {
        if (problemStatus.equals("Theorem")) {
            this.problemStatus = ProvabilityStatus.PROVABLE;
        } else if (problemStatus.equals("Non-Theorem")) {
            this.problemStatus = ProvabilityStatus.UNPROVABLE;
        } else if (problemStatus.equals("Unsolved")) {
            this.problemStatus = ProvabilityStatus.UNKNOWN;
        } else {
            throw new ProblemDescriptionException(String.format("Unknown status string [%s]", problemStatus));
        }
    }
}

