/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.modal.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwb.util.ContractViolationImplementationError;
import jtabwb.util.ImplementationError;
import jtabwbx.modal.basic.ModalConnective;
import jtabwbx.modal.basic.ModalFormulaType;
import jtabwbx.modal.btformula.BTModalFormula;
import jtabwbx.modal.btformula.BTModalFormulaProposition;
import jtabwbx.modal.formula.AbstractCompoundModalFormula;
import jtabwbx.modal.formula.BitSetOfModalFormulas;
import jtabwbx.modal.formula.FromParseTreeFormulaBuilder;
import jtabwbx.modal.formula.ModalFormula;
import jtabwbx.modal.formula.ModalFormulaAnd;
import jtabwbx.modal.formula.ModalFormulaBOX;
import jtabwbx.modal.formula.ModalFormulaDIA;
import jtabwbx.modal.formula.ModalFormulaIff;
import jtabwbx.modal.formula.ModalFormulaImplies;
import jtabwbx.modal.formula.ModalFormulaNot;
import jtabwbx.modal.formula.ModalFormulaOr;
import jtabwbx.modal.formula.ModalFormulaProposition;
import jtabwbx.modal.parser.ParsedModalFormula;

public class ModalFormulaFactory {
    private final Map<String, ModalFormulaProposition> propositions;
    private final Map<AbstractCompoundModalFormula, AbstractCompoundModalFormula> formulaCompounds;
    private final ArrayList<ModalFormula> formulasByIndex;
    private BitSetOfModalFormulas[] formulasByType;
    private BitSetOfModalFormulas generatedFormulas;
    private int formulaCounter;
    boolean translateIff = false;
    boolean translateDiamond = false;
    private String FALSE_NAME = "false";
    private String TRUE_NAME = "true";
    public final ModalFormulaProposition FALSE;
    public final ModalFormulaProposition TRUE;

    public ModalFormulaFactory(String falseName, String trueName) {
        if (trueName.equals(falseName)) {
            throw new ContractViolationImplementationError("Names for false and true constants must be different.");
        }
        this.formulaCounter = 0;
        this.propositions = new HashMap<String, ModalFormulaProposition>(100, 0.5f);
        this.formulaCompounds = new HashMap<AbstractCompoundModalFormula, AbstractCompoundModalFormula>(100, 0.5f);
        this.formulasByIndex = new ArrayList(50);
        this.generatedFormulas = new BitSetOfModalFormulas(this);
        this.formulasByType = new BitSetOfModalFormulas[ModalFormulaType.values().length];
        for (int i = 0; i < this.formulasByType.length; ++i) {
            this.formulasByType[i] = new BitSetOfModalFormulas(this);
        }
        this.FALSE_NAME = falseName;
        this.FALSE = this.buildAtomic(this.FALSE_NAME);
        this.TRUE_NAME = trueName;
        this.TRUE = this.buildAtomic(this.TRUE_NAME);
    }

    public ModalFormulaFactory() {
        this("false", "true");
    }

    public int numberOfGeneratedFormulas() {
        return this.formulaCounter;
    }

    public ArrayList<ModalFormula> generatedFormulas() {
        return (ArrayList)this.formulasByIndex.clone();
    }

    public ModalFormulaProposition getTrue() {
        return this.TRUE;
    }

    public ModalFormulaProposition getFalse() {
        return this.FALSE;
    }

    public BitSetOfModalFormulas getGeneratedFormula() {
        return this.generatedFormulas;
    }

    public BitSetOfModalFormulas getGeneratedFormulasOfType(ModalFormulaType type) {
        return this.formulasByType[type.ordinal()];
    }

    public ModalFormulaProposition buildAtomic(String name) {
        ModalFormulaProposition newProp = this.propositions.get(name);
        if (newProp == null) {
            newProp = new ModalFormulaProposition(this, name, name.equals(this.TRUE_NAME), name.equals(this.FALSE_NAME));
            newProp.size = 1;
            this.propositions.put(name, newProp);
            newProp.setIndex(this.formulaCounter++);
            this.formulasByIndex.add(newProp);
            this.generatedFormulas.add(newProp);
            this.formulasByType[newProp.getFormulaType().ordinal()].add(newProp);
        }
        return newProp;
    }

    public ModalFormula buildCompound(ModalConnective mainConnective, ModalFormula ... subFormulas) {
        AbstractCompoundModalFormula newFormula;
        if (mainConnective.arity() != subFormulas.length) {
            throw new ImplementationError("Wrong numeber of arguments: arity " + mainConnective.arity() + ", subformulas " + subFormulas.length);
        }
        switch (mainConnective) {
            case NOT: {
                newFormula = new ModalFormulaNot(this, subFormulas[0]);
                break;
            }
            case BOX: {
                newFormula = new ModalFormulaBOX(this, subFormulas[0]);
                break;
            }
            case DIA: {
                if (this.translateDiamond) {
                    ModalFormula NegA = this.buildCompound(ModalConnective.NOT, subFormulas[0]);
                    ModalFormula BoxNegA = this.buildCompound(ModalConnective.BOX, NegA);
                    newFormula = new ModalFormulaNot(this, BoxNegA);
                    break;
                }
                newFormula = new ModalFormulaDIA(this, subFormulas[0]);
                break;
            }
            case IMPLIES: {
                newFormula = new ModalFormulaImplies(this, subFormulas[0], subFormulas[1]);
                break;
            }
            case EQ: {
                if (this.translateIff) {
                    ModalFormula leftToRight = this.buildCompound(ModalConnective.IMPLIES, subFormulas[0], subFormulas[1]);
                    ModalFormula rightToLeft = this.buildCompound(ModalConnective.IMPLIES, subFormulas[1], subFormulas[0]);
                    newFormula = new ModalFormulaAnd(this, leftToRight, rightToLeft);
                    break;
                }
                newFormula = new ModalFormulaIff(this, subFormulas[0], subFormulas[1]);
                break;
            }
            case AND: {
                newFormula = new ModalFormulaAnd(this, subFormulas[0], subFormulas[1]);
                break;
            }
            case OR: {
                newFormula = new ModalFormulaOr(this, subFormulas[0], subFormulas[1]);
                break;
            }
            default: {
                throw new CaseNotImplementedImplementationError(mainConnective.getName());
            }
        }
        return this.getCanonicalFormula(newFormula);
    }

    private AbstractCompoundModalFormula getCanonicalFormula(AbstractCompoundModalFormula newFormula) {
        AbstractCompoundModalFormula canonicalFormula = this.formulaCompounds.get(newFormula);
        if (canonicalFormula == null) {
            this.formulaCompounds.put(newFormula, newFormula);
            canonicalFormula = newFormula;
            canonicalFormula.setIndex(this.formulaCounter++);
            this.formulasByIndex.add(canonicalFormula);
            this.generatedFormulas.add(canonicalFormula);
            this.formulasByType[canonicalFormula.getFormulaType().ordinal()].add(canonicalFormula);
        }
        return canonicalFormula;
    }

    public ModalFormula getByIndex(int index) {
        return this.formulasByIndex.get(index);
    }

    public ModalFormula buildFrom(ModalFormula wff) {
        if (wff.isAtomic()) {
            return this.buildAtomic(((ModalFormulaProposition)wff).getName());
        }
        ModalConnective mainConnective = wff.mainConnective();
        switch (mainConnective) {
            case IMPLIES: 
            case EQ: 
            case AND: 
            case OR: {
                ModalFormula left = this.buildFrom(wff.immediateSubformulas()[0]);
                ModalFormula right = this.buildFrom(wff.immediateSubformulas()[1]);
                return this.buildCompound(mainConnective, left, right);
            }
            case NOT: 
            case BOX: 
            case DIA: {
                return this.buildCompound(mainConnective, this.buildFrom(wff.immediateSubformulas()[0]));
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }

    public ModalFormula buildFrom(BTModalFormula wff) {
        if (wff.isAtomic()) {
            return this.buildAtomic(((BTModalFormulaProposition)wff).getName());
        }
        ModalConnective mainConnective = wff.mainConnective();
        ModalFormula translation = null;
        switch (mainConnective) {
            case IMPLIES: 
            case EQ: 
            case AND: 
            case OR: {
                ModalFormula left = this.buildFrom(wff.immediateSubformulas()[0]);
                ModalFormula right = this.buildFrom(wff.immediateSubformulas()[1]);
                translation = this.buildCompound(mainConnective, left, right);
                break;
            }
            case NOT: 
            case BOX: 
            case DIA: {
                translation = this.buildCompound(mainConnective, this.buildFrom(wff.immediateSubformulas()[0]));
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
            }
        }
        return translation;
    }

    public ModalFormula buildFrom(ParsedModalFormula parsed) {
        FromParseTreeFormulaBuilder builder = new FromParseTreeFormulaBuilder(this);
        return builder.buildFrom(parsed);
    }

    public void setTranslateEquivalences(boolean b) {
        this.translateIff = b;
    }

    public void setTranslateDiamond(boolean b) {
        this.translateIff = b;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("propositions: " + this.propositions.size() + "\n");
        sb.append("compound formulas: " + this.formulaCompounds.size() + "\n");
        sb.append("List of formulas");
        for (int i = 0; i < this.formulasByIndex.size(); ++i) {
            ModalFormula wff = this.formulasByIndex.get(i);
            sb.append(wff.getIndex() + "- " + wff.format());
            if (i >= this.formulasByIndex.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getDescription() {
        return "Modal formula factory";
    }
}

