/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.modal.btformula;

import java.util.HashMap;
import jtabwb.util.ImplementationError;
import jtabwbx.modal.basic.ModalConnective;
import jtabwbx.modal.btformula.BTModalFormula;
import jtabwbx.modal.btformula.BTModalFormulaBuilder;
import jtabwbx.modal.btformula.BTModalFormulaCompound;
import jtabwbx.modal.btformula.BTModalFormulaProposition;
import jtabwbx.modal.parser.ParsedModalFormula;

public class BTModalFormulaFactory {
    private HashMap<String, BTModalFormulaProposition> varManager = new HashMap();
    public static final BTModalFormulaProposition FALSE = BTModalFormulaProposition.FALSE;
    public static final BTModalFormulaProposition TRUE = BTModalFormulaProposition.TRUE;

    public BTModalFormulaFactory() {
        this.varManager.put(TRUE.getName(), TRUE);
        this.varManager.put(FALSE.getName(), FALSE);
    }

    public BTModalFormula buildAtomic(String name) {
        BTModalFormulaProposition prop = this.varManager.get(name);
        if (prop == null) {
            prop = new BTModalFormulaProposition(name);
            this.varManager.put(name, prop);
        }
        return prop;
    }

    public BTModalFormula buildCompound(ModalConnective mainConnective, BTModalFormula ... subformulas) {
        if (subformulas == null ? mainConnective.arity() != 0 : subformulas.length != mainConnective.arity()) {
            throw new ImplementationError("Wrong number of subformulas");
        }
        try {
            BTModalFormulaCompound wff;
            switch (mainConnective) {
                case NOT: 
                case BOX: 
                case DIA: {
                    wff = new BTModalFormulaCompound(mainConnective, subformulas[0]);
                    break;
                }
                case AND: 
                case OR: 
                case IMPLIES: 
                case EQ: {
                    wff = new BTModalFormulaCompound(mainConnective, subformulas[0], subformulas[1]);
                    break;
                }
                default: {
                    throw new ImplementationError();
                }
            }
            return wff;
        }
        catch (ClassCastException e) {
            throw new ImplementationError("Wrong logical constant: " + mainConnective.getName() + this.getClass().toString());
        }
    }

    public BTModalFormula buildFrom(ParsedModalFormula parsed) {
        BTModalFormulaBuilder builder = new BTModalFormulaBuilder();
        return builder.buildFrom(parsed);
    }

    public String getDescription() {
        return null;
    }
}

