/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.modal.btformula;

import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwbx.modal.basic.ModalConnective;
import jtabwbx.modal.btformula.BTModalFormula;

public class BTModalFormulaCompound
extends BTModalFormula {
    private ModalConnective mainConnective;
    private BTModalFormula[] subformulas;

    public BTModalFormulaCompound(ModalConnective mainConnective, BTModalFormula left, BTModalFormula right) {
        this.subformulas = new BTModalFormula[]{left, right};
        this.mainConnective = mainConnective;
    }

    public BTModalFormulaCompound(ModalConnective mainConnective, BTModalFormula sub) {
        this.subformulas = new BTModalFormula[]{sub};
        this.mainConnective = mainConnective;
    }

    @Override
    public String shortName() {
        return this.mainConnective.getName() + "-formula";
    }

    @Override
    public BTModalFormula[] immediateSubformulas() {
        return this.subformulas;
    }

    @Override
    public ModalConnective mainConnective() {
        return this.mainConnective;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public BTModalFormula convertToCNF() {
        switch (this.mainConnective) {
            case AND: {
                return new BTModalFormulaCompound(ModalConnective.AND, this.subformulas[0].convertToCNF(), this.subformulas[1].convertToCNF());
            }
            case OR: {
                BTModalFormula left = this.buildNegModuloDoubleNegation(this.subformulas[0].convertToCNF());
                BTModalFormula right = this.buildNegModuloDoubleNegation(this.subformulas[1].convertToCNF());
                return new BTModalFormulaCompound(ModalConnective.NOT, new BTModalFormulaCompound(ModalConnective.AND, left, right));
            }
            case IMPLIES: {
                BTModalFormula left = this.subformulas[0].convertToCNF();
                BTModalFormula right = this.buildNegModuloDoubleNegation(this.subformulas[1].convertToCNF());
                return new BTModalFormulaCompound(ModalConnective.NOT, new BTModalFormulaCompound(ModalConnective.AND, left, right));
            }
            case EQ: {
                BTModalFormula Acnf = this.subformulas[0].convertToCNF();
                BTModalFormula Bcnf = this.subformulas[1].convertToCNF();
                BTModalFormulaCompound AimpliesB = new BTModalFormulaCompound(ModalConnective.NOT, new BTModalFormulaCompound(ModalConnective.AND, Acnf, this.buildNegModuloDoubleNegation(Bcnf)));
                BTModalFormulaCompound BimpliesA = new BTModalFormulaCompound(ModalConnective.NOT, new BTModalFormulaCompound(ModalConnective.AND, Bcnf, this.buildNegModuloDoubleNegation(Acnf)));
                return new BTModalFormulaCompound(ModalConnective.AND, AimpliesB, BimpliesA);
            }
            case NOT: {
                return this.buildNegModuloDoubleNegation(this.subformulas[0].convertToCNF());
            }
            case BOX: {
                return new BTModalFormulaCompound(ModalConnective.BOX, this.subformulas[0].convertToCNF());
            }
            case DIA: {
                return new BTModalFormulaCompound(ModalConnective.NOT, new BTModalFormulaCompound(ModalConnective.BOX, this.buildNegModuloDoubleNegation(this.subformulas[0].convertToCNF())));
            }
        }
        throw new CaseNotImplementedImplementationError(this.mainConnective.getName());
    }

    private BTModalFormula buildNegModuloDoubleNegation(BTModalFormula wff) {
        if (wff.isCompound() && wff.mainConnective() == ModalConnective.NOT) {
            return wff.immediateSubformulas()[0];
        }
        return new BTModalFormulaCompound(ModalConnective.NOT, wff);
    }

    public String toString() {
        Object str = "";
        switch (this.mainConnective) {
            case BOX: 
            case DIA: {
                BTModalFormula left = this.subformulas[0];
                Object subf = "";
                if (left.isAtomic()) {
                    subf = " " + left.toString();
                } else {
                    switch (left.mainConnective()) {
                        case NOT: 
                        case BOX: 
                        case DIA: {
                            subf = "(" + left.toString() + ")";
                            break;
                        }
                        default: {
                            subf = left.toString();
                        }
                    }
                }
                str = this.mainConnective().toString() + (String)subf;
                break;
            }
            case NOT: {
                BTModalFormula left = this.subformulas[0];
                Object subf = "";
                if (left.isAtomic()) {
                    subf = left.toString();
                } else {
                    switch (left.mainConnective()) {
                        case NOT: 
                        case BOX: 
                        case DIA: {
                            subf = "(" + left.toString() + ")";
                            break;
                        }
                        default: {
                            subf = left.toString();
                        }
                    }
                }
                str = this.mainConnective().toString() + (String)subf;
                break;
            }
            case AND: 
            case OR: 
            case IMPLIES: 
            case EQ: {
                int i;
                BTModalFormula[] subformulas = this.immediateSubformulas();
                String[] subformulasString = new String[subformulas.length];
                for (i = 0; i < subformulasString.length; ++i) {
                    subformulasString[i] = subformulas[i].toString();
                }
                for (i = 0; i < subformulasString.length; ++i) {
                    str = (String)str + subformulasString[i] + (String)(i < subformulasString.length - 1 ? " " + this.mainConnective.toString() + " " : "");
                }
                str = "(" + (String)str + ")";
                break;
            }
            default: {
                throw new CaseNotImplementedImplementationError(this.mainConnective.getName());
            }
        }
        return str;
    }
}

