/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.tracesupport;

import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.engine.ProverName;
import jtabwb.engine.Trace;
import jtabwb.engine._Prover;
import jtabwb.engine._Strategy;
import jtabwb.tracesupport.TraceSupportException;
import jtabwb.tracesupport.TraceSupportMessageManager;
import jtabwb.tracesupport.ValidatorStrategy;
import jtabwb.tracesupport._TraceManager;

public class Validator
implements _Prover {
    private static String DESCRIPTION = "Trace validator";
    private static String NAME = "trace_validator";
    private _Prover prover;
    private _Strategy strategy;
    private ProverName proverName;

    public Validator(Trace trace, _Prover prover, _TraceManager traceManager) {
        if (trace.getStatus() != ProofSearchResult.SUCCESS) {
            throw new TraceSupportException(TraceSupportMessageManager.getMsg("validate.trace.is.not.a.proof", trace.getStatus().name()));
        }
        if (!trace.isPruned()) {
            throw new TraceSupportException(TraceSupportMessageManager.getMsg("validate.trace.is.not.pruned"));
        }
        this.strategy = new ValidatorStrategy(trace, traceManager);
        this.prover = prover;
        this.proverName = new ProverName(NAME + "[" + trace.getProver().getProverName().getDetailedName() + "]");
        this.proverName.setDescription(DESCRIPTION + "for [" + trace.getProver().getProverName().getDetailedName() + "]");
    }

    @Override
    public ProverName getProverName() {
        return this.proverName;
    }

    @Override
    public _Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ProvabilityStatus statusFor(ProofSearchResult result) {
        return this.prover.statusFor(result);
    }
}

