/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.tracesupport;

import java.io.PrintStream;
import java.util.LinkedList;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.Trace;
import jtabwb.engine.TraceNode;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.tracesupport.ImplementationError;
import jtabwb.tracesupport.TraceSupportException;
import jtabwb.tracesupport.TraceSupportMessageManager;
import jtabwb.tracesupport._LatexCTreeFormatter;

public class LatexTranslator {
    private Trace trace;
    private _LatexCTreeFormatter formatter;
    private ProofStyle style;
    private final String LATEX_PREAMBLE = "\\documentclass[10pt]{article}\n\\usepackage{color}\n\\usepackage{xifthen}\n\\pdfpagewidth 200in\n\\pdfpageheight 100in\n\\DeclareMathSizes{10}{12}{12}{8}\n";
    private final String SEQ_MACRO = "\\usepackage{proof}\n";
    private final String TAB_MACRO = "\\newcommand{\\Tab}[3]{\\frac{\\phantom{a}\\stackrel{\\textstyle #1}{\\phantom{\\scriptscriptstyle .}}\\phantom{a}}{\\stackrel{\\phantom{\\scriptscriptstyle .}}{\\textstyle #2}}{\\scriptstyle #3} }";
    private final String LATEX_BEGIN_DOCUMENT = "\\begin{document}\n\\thispagestyle{empty}\n";
    private final String LATEX_BEGIN_PROOF = "\\[\n";
    private final String LATEX_END_PROOF = "\\]\n";
    private final String LATEX_END_COCUMENT = "\\end{document}";
    private final String INFER_FORMAT_1 = "\\infer[";
    private final String INFER_FORMAT_2 = "]{\n";
    private final String INFER_FORMAT_3 = "}{\n";
    private final String INFER_FORMAT_4 = "}\n";
    private final String INFER_FORMAT_AND = "&\n";
    private final String TAB_FORMAT_1 = "\\Tab{";
    private final String TAB_FORMAT_2 = "\n}{";
    private final String TAB_FORMAT_3 = "\n}{";
    private final String TAB_FORMAT_4 = "\n}";
    private final String TAB_FORMAT_OR = "~|~";

    public LatexTranslator(Trace trace, _LatexCTreeFormatter formatter) throws TraceSupportException {
        if (trace.getStatus() != ProofSearchResult.SUCCESS) {
            throw new TraceSupportException(TraceSupportMessageManager.getMsg("latex.trace.is.not.a.proof", trace.getStatus().name()));
        }
        if (!trace.isPruned()) {
            throw new TraceSupportException(TraceSupportMessageManager.getMsg("latex.trace.is.not.pruned"));
        }
        this.trace = trace;
        this.formatter = formatter;
    }

    public void generateLatex(PrintStream out) {
        switch (this.formatter.proofStyle()) {
            case SEQUENT: {
                this.generateSequentStyle(out);
                break;
            }
            case TABLEAUX: {
                this.generateTableauxStyle(out);
                break;
            }
            default: {
                throw new ImplementationError("Case not treated [" + this.style.name() + "].");
            }
        }
    }

    private void generateSequentStyle(PrintStream out) {
        out.print("\\documentclass[10pt]{article}\n\\usepackage{color}\n\\usepackage{xifthen}\n\\pdfpagewidth 200in\n\\pdfpageheight 100in\n\\DeclareMathSizes{10}{12}{12}{8}\n");
        out.print("\\usepackage{proof}\n");
        String str = this.formatter.getPreamble();
        if (str != null) {
            out.print(str);
        }
        out.print("\\begin{document}\n\\thispagestyle{empty}\n");
        str = this.formatter.getIntro();
        if (str != null) {
            out.print(str);
        }
        out.print("\\[\n");
        _AbstractGoal initialNodeSet = this.trace.getInitialNodeSet();
        this._proofSequent(out, this.trace.getProofSearchTree(), initialNodeSet);
        out.print("\\]\n");
        out.print("\\end{document}");
    }

    private void _proofSequent(PrintStream out, TraceNode node, _AbstractGoal premise) {
        _AbstractRule rule = node.getAppliedRule();
        out.print("\\infer[");
        out.print(this.formatter.formatRuleName(rule));
        out.print("]{\n");
        out.print(this.formatter.format(premise));
        out.print("}{\n");
        LinkedList<TraceNode> children = node.getChildren();
        if (children != null) {
            TraceNode[] premises = children.toArray(new TraceNode[children.size()]);
            for (int i = 0; i < premises.length; ++i) {
                this._proofSequent(out, premises[i], premises[i].getPremise());
                if (i >= premises.length - 1) continue;
                out.print("&\n");
            }
        }
        out.print("}\n");
    }

    private void generateTableauxStyle(PrintStream out) {
        out.print("\\documentclass[10pt]{article}\n\\usepackage{color}\n\\usepackage{xifthen}\n\\pdfpagewidth 200in\n\\pdfpageheight 100in\n\\DeclareMathSizes{10}{12}{12}{8}\n");
        out.print("\\newcommand{\\Tab}[3]{\\frac{\\phantom{a}\\stackrel{\\textstyle #1}{\\phantom{\\scriptscriptstyle .}}\\phantom{a}}{\\stackrel{\\phantom{\\scriptscriptstyle .}}{\\textstyle #2}}{\\scriptstyle #3} }");
        String str = this.formatter.getPreamble();
        if (str != null) {
            out.print(str);
        }
        out.print("\\begin{document}\n\\thispagestyle{empty}\n");
        str = this.formatter.getIntro();
        if (str != null) {
            out.print(str);
        }
        out.print("\\[\n");
        _AbstractGoal initialNodeSet = this.trace.getInitialNodeSet();
        this._proofTableaux(out, this.trace.getProofSearchTree(), initialNodeSet);
        out.print("\\]\n");
        out.print("\\end{document}");
    }

    private void _proofTableaux(PrintStream out, TraceNode node, _AbstractGoal premise) {
        _AbstractRule rule = node.getAppliedRule();
        out.print("\\Tab{");
        out.print(this.formatter.format(premise));
        out.print("\n}{");
        LinkedList<TraceNode> children = node.getChildren();
        if (children != null) {
            TraceNode[] premises = children.toArray(new TraceNode[children.size()]);
            for (int i = 0; i < premises.length; ++i) {
                this._proofTableaux(out, premises[i], premises[i].getPremise());
                if (i >= premises.length - 1) continue;
                out.print("~|~");
            }
        }
        out.print("\n}{");
        out.print(this.formatter.formatRuleName(rule));
        out.print("\n}");
    }

    public static enum ProofStyle {
        SEQUENT,
        TABLEAUX;

    }
}

