/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.tracesupport;

import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.TraceNode;
import jtabwb.engine._RegularRule;
import jtabwb.tracesupport.CTreeNode;
import jtabwb.tracesupport.ChildrenWithCtreeNodes;
import jtabwb.tracesupport.CollectionOfArrayOfNCTrees;
import jtabwb.tracesupport.ImplementationError;
import jtabwb.tracesupport.SequenceOfCtreeNodes;

class CombinatorialCTreeGenerator {
    TraceNode currentTrace;
    int appliedRuleNumberOfConclusions;
    CTreeNode parent;
    _RegularRule appliedRule;
    ChildrenWithCtreeNodes childrenWithNodes;
    CollectionOfArrayOfNCTrees[] succesfulUpTo;

    public CombinatorialCTreeGenerator(TraceNode currentTraceNode, CTreeNode parent, ChildrenWithCtreeNodes successorTrees) {
        this.childrenWithNodes = successorTrees;
        this.currentTrace = currentTraceNode;
        this.parent = parent;
        this.appliedRule = (_RegularRule)currentTraceNode.getAppliedRule();
        this.appliedRuleNumberOfConclusions = this.appliedRule.numberOfSubgoals();
        this.succesfulUpTo = new CollectionOfArrayOfNCTrees[currentTraceNode.getChildren().size()];
    }

    SequenceOfCtreeNodes generates() {
        SequenceOfCtreeNodes successfull = this.generateSuccesfull();
        SequenceOfCtreeNodes failed = this.generateFailed();
        if (successfull != null) {
            if (failed != null) {
                successfull.addAll(failed);
            }
            return successfull;
        }
        return failed;
    }

    SequenceOfCtreeNodes generateSuccesfull() {
        CollectionOfArrayOfNCTrees subderivations = this.succesfulUpToIndex(this.appliedRuleNumberOfConclusions - 1);
        if (subderivations.isEmpty()) {
            return null;
        }
        SequenceOfCtreeNodes succesful = new SequenceOfCtreeNodes();
        for (CTreeNode[] sub : subderivations) {
            CTreeNode ctree = new CTreeNode(this.currentTrace, this.parent, this.currentTrace.getNodeDeterminingPremiseTreatedConclusion(), ProofSearchResult.SUCCESS);
            for (CTreeNode c : sub) {
                ctree.addSuccessor(c);
            }
            succesful.add(ctree);
        }
        return succesful;
    }

    SequenceOfCtreeNodes generateFailed() {
        CollectionOfArrayOfNCTrees subderivations = this.failedUpToIndex(this.childrenWithNodes.numberOfChildren() - 1);
        if (subderivations.isEmpty()) {
            return null;
        }
        SequenceOfCtreeNodes failed = new SequenceOfCtreeNodes();
        for (CTreeNode[] sub : subderivations) {
            CTreeNode ctree = new CTreeNode(this.currentTrace, this.parent, this.currentTrace.getNodeDeterminingPremiseTreatedConclusion(), ProofSearchResult.FAILURE);
            for (CTreeNode c : sub) {
                ctree.addSuccessor(c);
            }
            failed.add(ctree);
        }
        return failed;
    }

    private CollectionOfArrayOfNCTrees failedUpToIndex(int n) {
        CollectionOfArrayOfNCTrees arrays = new CollectionOfArrayOfNCTrees(n + 1);
        if (n == 0) {
            if (this.childrenWithNodes.failedCTreesOfChild(0) != null) {
                for (CTreeNode ct : this.childrenWithNodes.failedCTreesOfChild(0)) {
                    arrays.generateCombinations(ct, null);
                }
            }
            return arrays;
        }
        if (this.childrenWithNodes.failedCTreesOfChild(n) == null) {
            return arrays;
        }
        CollectionOfArrayOfNCTrees succesfull = this.succesfulUpToIndex(n - 1);
        if (succesfull.isEmpty()) {
            throw new ImplementationError();
        }
        for (CTreeNode ct : this.childrenWithNodes.failedCTreesOfChild(n)) {
            arrays.generateCombinations(ct, succesfull);
        }
        return arrays;
    }

    private CollectionOfArrayOfNCTrees succesfulUpToIndex(int n) {
        CollectionOfArrayOfNCTrees result = new CollectionOfArrayOfNCTrees(n + 1);
        for (int i = 0; i <= n; ++i) {
            if (this.childrenWithNodes.succesfulCTreesOfChild(i) != null) continue;
            return result;
        }
        if (this.succesfulUpTo[n] != null) {
            return this.succesfulUpTo[n];
        }
        for (CTreeNode ct : this.childrenWithNodes.succesfulCTreesOfChild(n)) {
            if (n == 0) {
                result.generateCombinations(ct, null);
                continue;
            }
            result.generateCombinations(ct, this.succesfulUpToIndex(n - 1));
        }
        this.succesfulUpTo[n] = result;
        return result;
    }
}

