/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.tracesupport;

import java.util.Iterator;
import java.util.LinkedList;
import jtabwb.tracesupport.CTreeNode;
import jtabwb.tracesupport.ImplementationError;

public class CollectionOfArrayOfNCTrees
implements Iterable<CTreeNode[]> {
    LinkedList<CTreeNode[]> arrays;
    private int arrayDimension;

    public CollectionOfArrayOfNCTrees(int arrayDimension) {
        this.arrayDimension = arrayDimension;
        this.arrays = new LinkedList();
    }

    public void generateCombinations(CTreeNode ct, CollectionOfArrayOfNCTrees prefixes) {
        if (prefixes == null) {
            if (this.arrayDimension != 1) {
                throw new ImplementationError();
            }
            this.arrays.add(new CTreeNode[]{ct});
        } else {
            if (prefixes.arrayDimension != this.arrayDimension - 1) {
                throw new ImplementationError();
            }
            for (CTreeNode[] prefix : prefixes.arrays) {
                this.arrays.add(this.extendWith(prefix, ct));
            }
        }
    }

    private CTreeNode[] extendWith(CTreeNode[] a, CTreeNode ct) {
        CTreeNode[] newa = new CTreeNode[a.length + 1];
        for (int i = 0; i < a.length; ++i) {
            newa[i] = a[i];
        }
        newa[newa.length - 1] = ct;
        return newa;
    }

    public boolean isEmpty() {
        return this.arrays.size() == 0;
    }

    @Override
    public Iterator<CTreeNode[]> iterator() {
        return this.arrays.iterator();
    }
}

