/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.tracesupport;

import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import jtabwb.engine.ForceBranchFailure;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._ClashDetectionRule;
import jtabwb.tracesupport.CTree;
import jtabwb.tracesupport.CTreeNode;
import jtabwb.tracesupport.ImplementationError;
import jtabwb.tracesupport.TraceSupportException;
import jtabwb.tracesupport._LatexCTreeFormatter;

class CTreeLatexGenerator {
    boolean index_node_set = false;
    boolean index_rule = false;
    private Collection<CTree> ctrees;
    private _LatexCTreeFormatter formatter;
    private ProofStyle style;
    private final String LATEX_PREAMBLE = "\\documentclass[10pt]{article}\n\\usepackage{color}\n\\usepackage{xifthen}\n\\pdfpagewidth 200in\n\\pdfpageheight 100in\n\\DeclareMathSizes{10}{12}{12}{8}\n\\pagestyle{empty}";
    private final String SEQ_MACRO = "\\usepackage{proof}\n";
    private final String TAB_MACRO = "\\newcommand{\\Tab}[3]{\\frac{\\phantom{a}\\stackrel{\\textstyle #1}{\\phantom{\\scriptscriptstyle .}}\\phantom{a}}{\\stackrel{\\phantom{\\scriptscriptstyle .}}{\\textstyle #2}}{\\scriptstyle #3} }";
    private final String LATEX_BEGIN_DOCUMENT = "\\begin{document}\n\\thispagestyle{empty}\n";
    private final String LATEX_BEGIN_PROOF = "\\[\n";
    private final String LATEX_END_PROOF = "\\]\n\\vspace{4ex}";
    private final String LATEX_END_COCUMENT = "\\end{document}";
    private final String INTEST = "\\noindent{\\Huge Number of generated C-trees: %d}\\vspace{4ex}\n\n";
    private final String CTREE_TITLE = "\\section*{C-tree %d, prover %s, status %s}";
    private final String INFER_FORMAT_1 = "\\infer[";
    private final String INFER_FORMAT_2 = "]{\n";
    private final String INFER_FORMAT_3 = "}{\n";
    private final String INFER_FORMAT_4 = "}\n";
    private final String INFER_FORMAT_AND = "&\n";
    private final String NODE_SET_INDEX = "\\mbox{$_{%d}$}";
    private final String RULE_INDEX = "\\mbox{\\small~$(%d)$}";
    private final String BRANCH_FAILURE_ANNOTATION_FMT = "\\item $\\sigma_{%d}$ brach FAILURE: $%s$";
    private final String NO_MORE_RULE_FAILURE_ANNOTATION_FMT = "\\item $\\sigma_{%d}$ no rule can be applied";
    int node_set_counter = 1;
    int rule_counter = 1;
    private final String TAB_FORMAT_1 = "\\Tab{";
    private final String TAB_FORMAT_2 = "\n}{";
    private final String TAB_FORMAT_3 = "\n}{";
    private final String TAB_FORMAT_4 = "\n}";
    private final String TAB_FORMAT_OR = "~|~";
    private static String[][] replacement = new String[][]{{"_", "\\\\_"}, {"\\$", "\\$"}};

    public CTreeLatexGenerator(CTree ctree, _LatexCTreeFormatter formatter) throws TraceSupportException {
        this.formatter = formatter;
        this.ctrees = new LinkedList<CTree>();
        this.ctrees.add(ctree);
        this.index_node_set = formatter.generateNodeSetIndex();
        this.index_rule = formatter.generateRuleIndex();
    }

    public CTreeLatexGenerator(Collection<CTree> ctrees, _LatexCTreeFormatter formatter) throws TraceSupportException {
        this.formatter = formatter;
        this.ctrees = ctrees;
        this.index_node_set = formatter.generateNodeSetIndex();
        this.index_rule = formatter.generateRuleIndex();
    }

    public void generateLatex(PrintStream out) {
        switch (this.formatter.proofStyle()) {
            case SEQUENT: 
            case TABLEAUX: {
                break;
            }
            default: {
                throw new ImplementationError("Case not treated [" + this.style.name() + "].");
            }
        }
        out.print("\\documentclass[10pt]{article}\n\\usepackage{color}\n\\usepackage{xifthen}\n\\pdfpagewidth 200in\n\\pdfpageheight 100in\n\\DeclareMathSizes{10}{12}{12}{8}\n\\pagestyle{empty}");
        switch (this.formatter.proofStyle()) {
            case SEQUENT: {
                out.print("\\usepackage{proof}\n");
                break;
            }
            case TABLEAUX: {
                out.print("\\newcommand{\\Tab}[3]{\\frac{\\phantom{a}\\stackrel{\\textstyle #1}{\\phantom{\\scriptscriptstyle .}}\\phantom{a}}{\\stackrel{\\phantom{\\scriptscriptstyle .}}{\\textstyle #2}}{\\scriptstyle #3} }");
            }
        }
        String str = this.formatter.getPreamble();
        if (str != null) {
            out.println(str + "\\par");
        }
        out.print("\\begin{document}\n\\thispagestyle{empty}\n");
        str = this.formatter.getIntro();
        if (str != null) {
            out.println(str + "\\par");
        }
        this._generateLatex(out);
        out.print("\\end{document}");
    }

    private void _generateLatex(PrintStream out) {
        if (this.ctrees.size() == 1) {
            String post;
            CTree ctree = this.ctrees.iterator().next();
            String pre = this.formatter.pre(ctree);
            out.print(pre == null ? "" : pre);
            out.print("\\[\n");
            LinkedList<String> annotations = new LinkedList<String>();
            switch (this.formatter.proofStyle()) {
                case SEQUENT: {
                    this._generateCTreeSequentSyle(out, this.ctrees.iterator().next().getRoot(), annotations);
                    break;
                }
                case TABLEAUX: {
                    this._generateCTreeTableauSyle(out, this.ctrees.iterator().next().getRoot(), annotations);
                }
            }
            out.print("\\]\n\\vspace{4ex}");
            if (this.formatter.generateFailureGoalAnnotations()) {
                this.printAnnotations(out, annotations);
            }
            out.print((post = this.formatter.post(ctree)) == null ? "" : post);
        } else {
            out.println(String.format("\\noindent{\\Huge Number of generated C-trees: %d}\\vspace{4ex}\n\n", this.ctrees.size()));
            int counter = 1;
            for (CTree ctree : this.ctrees) {
                String post;
                out.println(String.format("\\section*{C-tree %d, prover %s, status %s}", counter++, CTreeLatexGenerator.correctName(ctree.getProver().getProverName().getProperNoun()), ctree.getStatus().toString()));
                String pre = this.formatter.pre(ctree);
                out.print(pre == null ? "" : pre);
                out.print("\\[\n");
                this.node_set_counter = 1;
                this.rule_counter = 1;
                LinkedList<String> annotations = new LinkedList<String>();
                switch (this.formatter.proofStyle()) {
                    case SEQUENT: {
                        this._generateCTreeSequentSyle(out, ctree.getRoot(), annotations);
                        break;
                    }
                    case TABLEAUX: {
                        this._generateCTreeTableauSyle(out, ctree.getRoot(), annotations);
                        break;
                    }
                    default: {
                        throw new ImplementationError();
                    }
                }
                out.print("\\]\n\\vspace{4ex}");
                if (this.formatter.generateFailureGoalAnnotations()) {
                    this.printAnnotations(out, annotations);
                }
                out.print((post = this.formatter.post(ctree)) == null ? "" : post);
                out.print("\n\n");
                out.print("\\newpage");
            }
        }
    }

    private void printAnnotations(PrintStream out, LinkedList<String> annotations) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        out.print("\\begin{itemize}\n");
        for (String s : annotations) {
            out.print(s);
        }
        out.print("\\end{itemize}\n\n");
    }

    private void _generateCTreeSequentSyle(PrintStream out, CTreeNode ctree, LinkedList<String> annotations) {
        _AbstractRule rule = ctree.getAppliedRule();
        _AbstractGoal premise = ctree.getNodeSet();
        if (rule instanceof _ClashDetectionRule && ctree.getStatus() == ProofSearchResult.FAILURE) {
            out.print(this.formatter.format(premise) + (this.index_node_set ? String.format("\\mbox{$_{%d}$}", this.node_set_counter) : ""));
            annotations.add(String.format("\\item $\\sigma_{%d}$ no rule can be applied", this.node_set_counter));
            ++this.node_set_counter;
        } else if (rule instanceof ForceBranchFailure) {
            out.print(this.formatter.format(premise) + (this.index_node_set ? String.format("\\mbox{$_{%d}$}", this.node_set_counter) : ""));
            annotations.add(String.format("\\item $\\sigma_{%d}$ brach FAILURE: $%s$", this.node_set_counter, this.formatter.formatRuleName(rule)));
            ++this.node_set_counter;
        } else {
            out.print("\\infer[");
            out.print(this.formatter.formatRuleName(rule) + (this.index_rule ? String.format("\\mbox{\\small~$(%d)$}", this.rule_counter++) : ""));
            out.print("]{\n");
            out.print(this.formatter.format(premise) + (this.index_node_set ? String.format("\\mbox{$_{%d}$}", this.node_set_counter++) : ""));
            out.print("}{\n");
            LinkedList<CTreeNode> children = ctree.getSuccessors();
            if (children != null) {
                CTreeNode[] premises = children.toArray(new CTreeNode[children.size()]);
                for (int i = 0; i < premises.length; ++i) {
                    this._generateCTreeSequentSyle(out, premises[i], annotations);
                    if (i >= premises.length - 1) continue;
                    out.print("&\n");
                }
            }
            out.print("}\n");
        }
    }

    private void _generateCTreeTableauSyle(PrintStream out, CTreeNode ctree, LinkedList<String> annotations) {
        _AbstractRule rule = ctree.getAppliedRule();
        _AbstractGoal premise = ctree.getNodeSet();
        if (rule instanceof _ClashDetectionRule && ctree.getStatus() == ProofSearchResult.FAILURE) {
            out.print(this.formatter.format(premise));
        } else {
            out.print("\\Tab{");
            out.print(this.formatter.format(premise));
            out.print("\n}{");
            LinkedList<CTreeNode> children = ctree.getSuccessors();
            if (children != null) {
                CTreeNode[] premises = children.toArray(new CTreeNode[children.size()]);
                for (int i = 0; i < premises.length; ++i) {
                    this._generateCTreeTableauSyle(out, premises[i], annotations);
                    if (i >= premises.length - 1) continue;
                    out.print("~|~");
                }
            }
            out.print("\n}{");
            out.print(this.formatter.formatRuleName(rule));
            out.print("\n}");
        }
    }

    private static String correctName(String name) {
        String result = name;
        for (int i = 0; i < replacement.length; ++i) {
            result = result.replaceAll(replacement[i][0], replacement[i][1]);
        }
        return result;
    }

    public static enum ProofStyle {
        SEQUENT,
        TABLEAUX;

    }
}

