/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.tracesupport;

import java.util.Collection;
import java.util.LinkedList;
import jtabwb.engine.RuleType;
import jtabwb.engine.Trace;
import jtabwb.engine.TraceNode;
import jtabwb.engine._AbstractRule;
import jtabwb.tracesupport.CTree;
import jtabwb.tracesupport.CTreeNode;
import jtabwb.tracesupport.ChildrenWithCtreeNodes;
import jtabwb.tracesupport.CombinatorialCTreeGenerator;
import jtabwb.tracesupport.ImplementationError;
import jtabwb.tracesupport.SequenceOfCtreeNodes;

class CTreeBuilder {
    private Trace trace;
    private int counter = 1;

    public CTreeBuilder(Trace trace) {
        this.trace = trace;
    }

    Collection<CTree> build() {
        TraceNode traceHead = this.trace.getProofSearchTree();
        SequenceOfCtreeNodes ctreeRoots = this._build(traceHead, null);
        if (ctreeRoots.size() == 0) {
            return null;
        }
        LinkedList<CTree> ctrees = new LinkedList<CTree>();
        for (CTreeNode root : ctreeRoots) {
            ctrees.add(new CTree(this.trace.getProver(), root, this.counter++));
        }
        return ctrees;
    }

    SequenceOfCtreeNodes _build(TraceNode currentTraceNode, CTreeNode parent) {
        _AbstractRule rule = currentTraceNode.getAppliedRule();
        RuleType ruleType = RuleType.getType(rule);
        switch (ruleType) {
            case FORCE_BRANCH_SUCCESS: 
            case FORCE_BRANCH_FAILURE: {
                SequenceOfCtreeNodes list = new SequenceOfCtreeNodes();
                list.add(new CTreeNode(currentTraceNode, parent, currentTraceNode.getNodeDeterminingPremiseTreatedConclusion(), currentTraceNode.getStatus()));
                return list;
            }
            case CLASH_DETECTION_RULE: {
                if (currentTraceNode.getChildren() != null) {
                    return this._build(currentTraceNode.getChildren().getFirst(), parent);
                }
                SequenceOfCtreeNodes list = new SequenceOfCtreeNodes();
                list.add(new CTreeNode(currentTraceNode, parent, currentTraceNode.getNodeDeterminingPremiseTreatedConclusion(), currentTraceNode.getStatus()));
                return list;
            }
            case META_BACKTRACK_RULE: {
                TraceNode[] children = currentTraceNode.getChildren().toArray(new TraceNode[currentTraceNode.getChildren().size()]);
                SequenceOfCtreeNodes result = new SequenceOfCtreeNodes();
                for (int i = 0; i < children.length; ++i) {
                    result.addAll(this._build(children[i], parent));
                }
                return result;
            }
            case BRANCH_EXISTS: {
                TraceNode[] children = currentTraceNode.getChildren().toArray(new TraceNode[currentTraceNode.getChildren().size()]);
                SequenceOfCtreeNodes result = new SequenceOfCtreeNodes();
                for (int i = 0; i < children.length; ++i) {
                    SequenceOfCtreeNodes subtrees = this._build(children[i], null);
                    for (CTreeNode subtree : subtrees) {
                        CTreeNode ct = new CTreeNode(currentTraceNode, parent, currentTraceNode.getNodeDeterminingPremiseTreatedConclusion(), subtree.getStatus());
                        ct.addSuccessor(subtree);
                        result.add(ct);
                    }
                }
                return result;
            }
            case REGULAR: {
                ChildrenWithCtreeNodes ctreesForChildren = new ChildrenWithCtreeNodes(currentTraceNode.getChildren());
                for (TraceNode child : currentTraceNode.getChildren()) {
                    ctreesForChildren.put(child, this._build(child, null));
                }
                CombinatorialCTreeGenerator cg = new CombinatorialCTreeGenerator(currentTraceNode, parent, ctreesForChildren);
                return cg.generates();
            }
        }
        throw new ImplementationError();
    }
}

