/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.DFStack;
import jtabwb.engine.DFStackNode;
import jtabwb.engine.DFStackNode_BranchExistsRule;
import jtabwb.engine.DFStackNode_MetaBacktrackRule;
import jtabwb.engine.DFStackNode_RegularRule;
import jtabwb.engine.ForceBranchFailure;
import jtabwb.engine.ForceBranchSuccess;
import jtabwb.engine.GoalNode;
import jtabwb.engine.IterationInfo;
import jtabwb.engine.RuleType;
import jtabwb.engine._AbstractFormula;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._ClashDetectionRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._OnRuleCompletedListener;
import jtabwb.engine._OnRuleResumedListener;
import jtabwb.engine._RegularRule;
import jtabwb.engine._RuleWithDetails;
import jtabwb.util.ImplementationError;

class VerboseModeSupport {
    private static String INDENT_STRING = "    ";
    private static final String INFO_TAB = "    ";

    VerboseModeSupport() {
    }

    static void print_InitialSetInfo(IterationInfo LAST_ITERATION_INFO, DFStack stack, GoalNode initialNodeSet) {
        VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
        VerboseModeSupport.iterationStepInfo("Initial goal: %s", initialNodeSet.formatAsEngineNode());
    }

    static void print_IterationDetails(IterationInfo LAST_ITERATION_INFO, DFStack stack) {
        VerboseModeSupport.println("[%s] ------------------------------------ [%s]", String.valueOf(LAST_ITERATION_INFO.number_of_iterations), LAST_ITERATION_INFO.move.name());
        if (LAST_ITERATION_INFO.branch_point_added) {
            VerboseModeSupport.iterationStepInfo("Stack size: [%s], AND-BRANCH POINT added", String.valueOf(stack.current_stack_size));
        } else if (LAST_ITERATION_INFO.backtrack_point_added) {
            VerboseModeSupport.iterationStepInfo("Stack size: [%s], BACKTRACK POINT added", String.valueOf(stack.current_stack_size));
        } else {
            VerboseModeSupport.iterationStepInfo("Stack size [%s]", String.valueOf(stack.current_stack_size));
        }
    }

    static void print_IterationInfo(IterationInfo LAST_ITERATION_INFO, DFStack stack, RuleType ruleType, _AbstractRule nextStepSelectedRule, GoalNode currentGoal) {
        switch (ruleType) {
            case CLASH_DETECTION_RULE: {
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.iterationStepInfo("Rule name: %s", LAST_ITERATION_INFO.applied_rule.name());
                VerboseModeSupport.iterationStepInfo("Clash status: %s", LAST_ITERATION_INFO.current_node_set_status.name());
                VerboseModeSupport.print_ClashDetectionDetails((_ClashDetectionRule)LAST_ITERATION_INFO.applied_rule);
                break;
            }
            case META_BACKTRACK_RULE: {
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.print_MetaBacktrackDetails((_MetaBacktrackRule)LAST_ITERATION_INFO.applied_rule, 0, nextStepSelectedRule, false);
                break;
            }
            case RESTORED_META_BACKTRACK_RULE: {
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                DFStackNode_MetaBacktrackRule rrule = (DFStackNode_MetaBacktrackRule)LAST_ITERATION_INFO.applied_rule;
                VerboseModeSupport.print_MetaBacktrackDetails(rrule, rrule.getIndexOfLastTreatedRule(), nextStepSelectedRule, true);
                break;
            }
            case REGULAR: {
                _RegularRule rrule = (_RegularRule)LAST_ITERATION_INFO.applied_rule;
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.print_RegularRuleApplicationDetails(rrule, 1, currentGoal, false);
                break;
            }
            case RESTORED_REGULAR: {
                DFStackNode_RegularRule rrule = (DFStackNode_RegularRule)LAST_ITERATION_INFO.applied_rule;
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.print_RegularRuleApplicationDetails(rrule, rrule.getIndexOfLastTreatedConclusion() + 1, currentGoal, true);
                break;
            }
            case BRANCH_EXISTS: {
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.print_BranchExistsDetails((_BranchExistsRule)LAST_ITERATION_INFO.applied_rule, 1, currentGoal, false);
                break;
            }
            case RESTORED_BRANCH_EXISTS: {
                DFStackNode_BranchExistsRule rrule = (DFStackNode_BranchExistsRule)LAST_ITERATION_INFO.applied_rule;
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.print_BranchExistsDetails(rrule, rrule.getIndexOfLastTreatedConclusion() + 1, currentGoal, true);
                break;
            }
            case FORCE_BRANCH_FAILURE: {
                ForceBranchFailure rule = (ForceBranchFailure)LAST_ITERATION_INFO.applied_rule;
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.print_ForceBranchFailureDetails(rule, currentGoal);
                break;
            }
            case FORCE_BRANCH_SUCCESS: {
                ForceBranchSuccess rule = (ForceBranchSuccess)LAST_ITERATION_INFO.applied_rule;
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.print_ForceBranchSuccessDetails(rule, currentGoal);
                break;
            }
            case AND_BRANCH_POINT_SEARCH: {
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                if (nextStepSelectedRule == null) {
                    VerboseModeSupport.iterationStepInfo("No more AND-branch points to resume; proof-search success.", new Object[0]);
                    break;
                }
                DFStackNode node = stack.restored_DFStackNode;
                VerboseModeSupport.iterationStepInfo("Found AND-branch point generated at step [%s] by rule [%s]", node.generated_at_iteration, node.appliedRule.name());
                VerboseModeSupport.iterationStepInfo("Restored node set: %s", node.getPremiseGoalNode().formatAsRestoredEngineNode());
                break;
            }
            case OR_BRANCH_POINT_SEARCH: {
                VerboseModeSupport.print_IterationDetails(LAST_ITERATION_INFO, stack);
                if (nextStepSelectedRule == null) {
                    VerboseModeSupport.iterationStepInfo("No more OR-backtrack points to resume; proof-search-failure.", new Object[0]);
                    break;
                }
                DFStackNode node = stack.restored_DFStackNode;
                VerboseModeSupport.iterationStepInfo("Found OR-branch point generated at step [%s] by rule [%s]", node.generated_at_iteration, node.appliedRule.name());
                VerboseModeSupport.iterationStepInfo("Restored node set: %s", node.getPremiseGoalNode().formatAsRestoredEngineNode());
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED_arg, (Object)ruleType);
            }
        }
    }

    static void print_ForceBranchSuccessDetails(ForceBranchSuccess appliedRule, GoalNode currentGoal) {
        VerboseModeSupport.iterationStepInfo("Rule name: %s", appliedRule.name());
        if (appliedRule instanceof _OnRuleCompletedListener) {
            VerboseModeSupport.iterationStepInfo("Added [on rule completed] listener for [%s]", appliedRule.name());
        }
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo("Details: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
    }

    static void print_ForceBranchFailureDetails(ForceBranchFailure appliedRule, GoalNode currentGoal) {
        if (appliedRule == null) {
            VerboseModeSupport.iterationStepInfo("No rule selected by the strategy", new Object[0]);
        } else {
            VerboseModeSupport.iterationStepInfo("Rule name: %s", appliedRule.name());
        }
        if (appliedRule instanceof _OnRuleCompletedListener) {
            VerboseModeSupport.iterationStepInfo("Added [on rule completed] listener for [%s]", appliedRule.name());
        }
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo("Details: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
    }

    static void print_RegularRuleApplicationDetails(_RegularRule appliedRule, int treatedConclusion, GoalNode currentGoal, boolean isARestoredRuleApplication) {
        _AbstractFormula treatedFormula = appliedRule.mainFormula();
        VerboseModeSupport.iterationStepInfo("Selected formula [%s]: %s", treatedFormula == null ? "[NONE]" : treatedFormula.shortName(), treatedFormula == null ? "[NONE]" : treatedFormula.format());
        int totalNumberoOfConclusions = appliedRule.numberOfSubgoals();
        VerboseModeSupport.iterationStepInfo("Rule name [%s], conclusions [%d], treating branch [%d of %2$d]", appliedRule.name(), totalNumberoOfConclusions, treatedConclusion);
        if (!isARestoredRuleApplication) {
            if (appliedRule instanceof _OnRuleCompletedListener) {
                VerboseModeSupport.iterationStepInfo("Added [on rule completed] listener for [%s]", appliedRule.name());
            }
            if (appliedRule instanceof _OnRuleResumedListener) {
                VerboseModeSupport.iterationStepInfo("Added [on rule resumed] listener for [%s]", appliedRule.name());
            }
        }
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo("Details: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
        VerboseModeSupport.iterationStepInfo("Generated node: %s", currentGoal.formatAsEngineNode());
    }

    static void print_ClashDetectionDetails(_ClashDetectionRule appliedRule) {
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo("Details: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
    }

    static void print_MetaBacktrackDetails(_MetaBacktrackRule appliedRule, int indexOfTreatedBacktrackRule, _AbstractRule nextStepSelectedRule, boolean isARestoredRuleApplication) {
        VerboseModeSupport.iterationStepInfo("Rule name [%s], rules to try [%d]", appliedRule.name(), appliedRule.totalNumberOfRules());
        RuleType nextStepType = RuleType.getType(nextStepSelectedRule);
        int totalNumberOfRules = appliedRule.totalNumberOfRules();
        switch (nextStepType) {
            case REGULAR: {
                VerboseModeSupport.iterationStepInfo("Rule [%d of %d] selected, [%s] on [%s]: %s", indexOfTreatedBacktrackRule + 1, totalNumberOfRules, nextStepSelectedRule.name(), ((_RegularRule)nextStepSelectedRule).mainFormula().shortName(), ((_RegularRule)nextStepSelectedRule).mainFormula().format());
                break;
            }
            case BRANCH_EXISTS: {
                VerboseModeSupport.iterationStepInfo("Rule [%d of %d] selected, [%s] on [%s]: %s", indexOfTreatedBacktrackRule + 1, totalNumberOfRules, nextStepSelectedRule.name(), ((_BranchExistsRule)nextStepSelectedRule).mainFormula().shortName(), ((_BranchExistsRule)nextStepSelectedRule).mainFormula().format());
                break;
            }
            default: {
                VerboseModeSupport.iterationStepInfo("Rule [%d of %d] selected, [%s]", nextStepSelectedRule.name());
            }
        }
        if (!isARestoredRuleApplication) {
            if (appliedRule instanceof _OnRuleCompletedListener) {
                VerboseModeSupport.iterationStepInfo("Added [on rule completed] listener for [%s]", appliedRule.name());
            }
            if (appliedRule instanceof _OnRuleResumedListener) {
                VerboseModeSupport.iterationStepInfo("Added [on rule resumed] listener for [%s]", appliedRule.name());
            }
        }
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo("Details: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
    }

    static void print_BranchExistsDetails(_BranchExistsRule appliedRule, int treatedConclusion, GoalNode currentGoal, boolean isARestoredRuleApplication) {
        _AbstractFormula treatedFormula = appliedRule.mainFormula();
        VerboseModeSupport.iterationStepInfo("Selected formula [%s]: %s", treatedFormula == null ? "[NONE]" : treatedFormula.shortName(), treatedFormula == null ? "[NONE]" : treatedFormula.format());
        VerboseModeSupport.iterationStepInfo("Rule name [%s], conclusions [%d], treating conclusion [%d of %2$d]", appliedRule.name(), appliedRule.numberOfBranchExistsSubgoals(), treatedConclusion);
        if (!isARestoredRuleApplication) {
            if (appliedRule instanceof _OnRuleCompletedListener) {
                VerboseModeSupport.iterationStepInfo("Added [on rule completed] listener for [%s]", appliedRule.name());
            }
            if (appliedRule instanceof _OnRuleResumedListener) {
                VerboseModeSupport.iterationStepInfo("Added [on rule resumed] listener for [%s]", appliedRule.name());
            }
        }
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo("Generated node: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
        VerboseModeSupport.iterationStepInfo("Generated node: %s", currentGoal.toString());
    }

    public static String indent(String str) {
        return str.replaceAll("\n", "\n" + INDENT_STRING);
    }

    static String indentWithPrefix(String prefix, String str) {
        String indent = INDENT_STRING + prefix;
        return indent + str.replaceAll("\n", "\n" + indent);
    }

    static void iterationStepInfo(String key, Object ... args) {
        System.out.println(INFO_TAB + String.format(key, args));
    }

    static void println(String key, Object ... args) {
        System.out.println(String.format(key, args));
    }

    static class MSG {
        MSG() {
        }

        static class BRANCH_POINT_SEARCH {
            static final String AND_BRANCH_POINT_FOUND = "Found AND-branch point generated at step [%s] by rule [%s]";
            static final String OR_BRANCH_POINT_FOUND = "Found OR-branch point generated at step [%s] by rule [%s]";
            static final String BRANCH_POINT_RESTORED_NODE = "Restored node set: %s";
            static final String BACKTRACK_TYPE = "Backtrack rule type [%s]";
            static final String BRANCH_POINT_RESUMED = "Resumed AND-BRANCH point generated at iteration [%d]";
            static final String BRANCH_POINT_RESUMED_NODE_SET = "Node set %s";
            static final String NO_MORE_OR_BRANCH_POINTS = "No more OR-backtrack points to resume; proof-search-failure.";
            static final String NO_MORE_AND_BRANCH_POINTS = "No more AND-branch points to resume; proof-search success.";

            BRANCH_POINT_SEARCH() {
            }
        }

        static class RULE_APPLICATION_DETAILS {
            static final String GENERATED_NODESET = "Generated node: %s";
            static final String BRANCH_EXISTS_NEXT_STEP = "Rule name [%s], conclusions [%d], treating conclusion [%d of %2$d]";
            static final String META_BACKTRACK_RULE_APPLICATION = "Rule name [%s], rules to try [%d]";
            static final String ON_RULE_COMPLETED_LISTENER = "Added [on rule completed] listener for [%s]";
            static final String ON_RULE_RESUMED_LISTENER = "Added [on rule resumed] listener for [%s]";
            static final String REGULAR_RULE_APPLICATION = "Rule name [%s], conclusions [%d], treating branch [%d of %2$d]";
            static final String RULE_DETAILS = "Details: %s";
            static final String SELECTED_BACKTRACK_RULE = "Rule [%d of %d] selected, [%s]";
            static final String SELECTED_BACKTRACK_RULE_FOR = "Rule [%d of %d] selected, [%s] on [%s]: %s";
            static final String SELECTED_MAIN_FORMULA = "Selected formula [%s]: %s";

            RULE_APPLICATION_DETAILS() {
            }
        }

        static class ITERATION_INFO {
            static final String BACKTRACK_POINT_ADDED = "Stack size: [%s], BACKTRACK POINT added";
            static final String AND_BRANCH_POINT_ADDED = "Stack size: [%s], AND-BRANCH POINT added";
            static final String RULE_NAME = "Rule name: %s";
            static final String NO_RULE_SELECTED_BY_THE_STRATEGY = "No rule selected by the strategy";
            static final String CLOSURE_CHECK = "Clash status: %s";
            static final String INITIAL_NODESET = "Initial goal: %s";
            static final String MAIN_CYCLE_ITERATION = "[%s] ------------------------------------ [%s]";
            static final String STACK_SIZE = "Stack size [%s]";
            static final String STACK_TRACE_BEGIN = "Stack trace -->";
            static final String STACK_TRACE_END = "<--";

            ITERATION_INFO() {
            }
        }
    }
}

