/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import jtabwb.engine.MSG;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.RuleType;
import jtabwb.engine.TraceException;
import jtabwb.engine.TraceIterator;
import jtabwb.engine.TraceNode;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._Prover;
import jtabwb.util.ImplementationError;

public class Trace
implements Iterable<TraceNode> {
    private _AbstractGoal initialNodeSet;
    private TraceNode head;
    private ProofSearchResult status;
    private boolean isPruned;
    private _Prover prover;

    Trace(_AbstractGoal initialNodeSet, _Prover prover, TraceNode head, ProofSearchResult status) {
        this.prover = prover;
        this.initialNodeSet = initialNodeSet;
        this.head = head;
        this.status = status;
        this.isPruned = false;
    }

    public TraceNode getProofSearchTree() {
        return this.head;
    }

    public _AbstractGoal getInitialNodeSet() {
        return this.initialNodeSet;
    }

    public _Prover getProver() {
        return this.prover;
    }

    public ProofSearchResult getStatus() {
        return this.status;
    }

    public boolean isPruned() {
        return this.isPruned;
    }

    @Override
    public Iterator<TraceNode> iterator() {
        return new TraceIterator(this);
    }

    public void pruneSuccessful() throws TraceException {
        if (this.status != ProofSearchResult.SUCCESS) {
            throw new TraceException(MSG.getMsg(MSG.TRACE.CANNOT_PRUNE, this.status.toString()));
        }
        this.pruneSuccessfulTrace(this.head);
        this.isPruned = true;
    }

    private void pruneSuccessfulTrace(TraceNode current) {
        _AbstractRule rule = current.appliedRule;
        RuleType ruleType = RuleType.getType(rule);
        switch (ruleType) {
            case CLASH_DETECTION_RULE: {
                if (current.getChildren() == null) break;
                if (current != this.head) {
                    TraceNode newNode = current.children.get(0);
                    current.parent.replaceChild(current, newNode);
                    newNode.parent = current.parent;
                    this.pruneSuccessfulTrace(newNode);
                    break;
                }
                this.head = current.children.get(0);
                this.pruneSuccessfulTrace(this.head);
                break;
            }
            case META_BACKTRACK_RULE: {
                if (current == this.head) {
                    this.head = current.children.getLast();
                    this.pruneSuccessfulTrace(this.head);
                    break;
                }
                TraceNode newNode = current.children.getLast();
                current.parent.replaceChild(current, newNode);
                newNode.parent = current.parent;
                this.pruneSuccessfulTrace(newNode);
                break;
            }
            case BRANCH_EXISTS: {
                TraceNode succesFullChild = current.children.getLast();
                current.children = new LinkedList();
                current.children.add(succesFullChild);
                this.pruneSuccessfulTrace(succesFullChild);
                break;
            }
            case REGULAR: {
                for (int i = 0; i < current.children.size(); ++i) {
                    this.pruneSuccessfulTrace(current.children.get(i));
                }
                break;
            }
            case FORCE_BRANCH_FAILURE: {
                break;
            }
            case FORCE_BRANCH_SUCCESS: {
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED_arg, ruleType.name());
            }
        }
    }

    public String toString() {
        return "Trace generated by [" + this.prover.getProverName().getDetailedName() + "] prover.\nTrace status: " + this.status.name() + "\nInitial node set:\n" + this.initialNodeSet.format();
    }

    public void print(PrintStream out) {
        out.println(this.toString());
        out.println("A trace node consists of: status, applied rule, successors, main formula.");
        for (TraceNode tn : this) {
            out.println(tn.toString());
        }
    }
}

