/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.AND_BRANCH_POINT_SEARCH;
import jtabwb.engine.DFStackNode_BranchExistsRule;
import jtabwb.engine.DFStackNode_MetaBacktrackRule;
import jtabwb.engine.DFStackNode_RegularRule;
import jtabwb.engine.ForceBranchFailure;
import jtabwb.engine.ForceBranchSuccess;
import jtabwb.engine.OR_BRANCH_POINT_SEARCH;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._ClashDetectionRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._RegularRule;
import jtabwb.util.ImplementationError;

public enum RuleType {
    BRANCH_EXISTS,
    RESTORED_BRANCH_EXISTS,
    CLASH_DETECTION_RULE,
    META_BACKTRACK_RULE,
    RESTORED_META_BACKTRACK_RULE,
    REGULAR,
    RESTORED_REGULAR,
    FORCE_BRANCH_FAILURE,
    FORCE_BRANCH_SUCCESS,
    AND_BRANCH_POINT_SEARCH,
    OR_BRANCH_POINT_SEARCH;


    public static RuleType getType(_AbstractRule ruleToApply) {
        if (ruleToApply == null) {
            return FORCE_BRANCH_FAILURE;
        }
        if (ruleToApply instanceof AND_BRANCH_POINT_SEARCH) {
            return AND_BRANCH_POINT_SEARCH;
        }
        if (ruleToApply instanceof OR_BRANCH_POINT_SEARCH) {
            return OR_BRANCH_POINT_SEARCH;
        }
        if (ruleToApply instanceof DFStackNode_RegularRule) {
            return RESTORED_REGULAR;
        }
        if (ruleToApply instanceof DFStackNode_BranchExistsRule) {
            return RESTORED_BRANCH_EXISTS;
        }
        if (ruleToApply instanceof DFStackNode_MetaBacktrackRule) {
            return RESTORED_META_BACKTRACK_RULE;
        }
        if (ruleToApply instanceof ForceBranchFailure) {
            return FORCE_BRANCH_FAILURE;
        }
        if (ruleToApply instanceof ForceBranchSuccess) {
            return FORCE_BRANCH_SUCCESS;
        }
        if (ruleToApply instanceof _ClashDetectionRule) {
            return CLASH_DETECTION_RULE;
        }
        if (ruleToApply instanceof _BranchExistsRule) {
            return BRANCH_EXISTS;
        }
        if (ruleToApply instanceof _MetaBacktrackRule) {
            return META_BACKTRACK_RULE;
        }
        if (ruleToApply instanceof _RegularRule) {
            return REGULAR;
        }
        throw new ImplementationError("Rule type unknown, object type [%s]", ruleToApply.getClass().getCanonicalName());
    }
}

