/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import java.util.LinkedList;
import jtabwb.engine.DFStack;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine._OnRuleCompletedListener;

class OnCompletedRuleHandler {
    private final DFStack dfStack;
    private final Node head;
    private Node top;

    public OnCompletedRuleHandler(DFStack dfStack) {
        this.dfStack = dfStack;
        this.head = new Node();
        this.head.nodeIndex = 0;
        this.top = this.head;
    }

    void add(_OnRuleCompletedListener listener) {
        if (this.dfStack.current_stack_size == this.top.nodeIndex) {
            this.top.listeners.addFirst(listener);
        } else {
            Node newNode = new Node();
            newNode.nodeIndex = this.dfStack.current_stack_size;
            newNode.listeners.addFirst(listener);
            newNode.previousNode = this.top;
            this.top = newNode;
        }
    }

    void notify(ProofSearchResult result, int endIndex) {
        boolean goon = true;
        while (goon && this.top.nodeIndex >= endIndex) {
            _OnRuleCompletedListener listener;
            while ((listener = this.top.listeners.pollFirst()) != null) {
                listener.onCompleted(result);
            }
            if (this.top != this.head) {
                this.top = this.top.previousNode;
                continue;
            }
            goon = false;
        }
    }

    private static class Node {
        Node previousNode;
        int nodeIndex;
        LinkedList<_OnRuleCompletedListener> listeners = new LinkedList();

        private Node() {
        }
    }
}

