/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.AND_BRANCH_POINT_SEARCH;
import jtabwb.engine.DFStack;
import jtabwb.engine.DFStackNode;
import jtabwb.engine.DFStackNode_BranchExistsRule;
import jtabwb.engine.DFStackNode_MetaBacktrackRule;
import jtabwb.engine.DFStackNode_RegularRule;
import jtabwb.engine.ForceBranchFailure;
import jtabwb.engine.ForceBranchSuccess;
import jtabwb.engine.GoalNode;
import jtabwb.engine.IterationInfo;
import jtabwb.engine.OR_BRANCH_POINT_SEARCH;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.RuleType;
import jtabwb.engine.VerboseModeSupport;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._ClashDetectionRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._OnRuleCompletedListener;
import jtabwb.engine._Prover;
import jtabwb.engine._RegularRule;
import jtabwb.engine._Strategy;
import jtabwb.util.ImplementationError;

class EnginePlain {
    _Prover prover;
    _Strategy strategy;
    _AbstractGoal goal;
    DFStack stack;
    ProofSearchResult result = null;
    GoalNode currentGoal;
    final IterationInfo LAST_ITERATION_INFO;
    boolean verboseMode;

    EnginePlain(_Prover prover, _AbstractGoal goal, DFStack stack, boolean verboseMode) {
        this.prover = prover;
        this.goal = goal;
        this.stack = stack;
        this.strategy = prover.getStrategy();
        this.result = null;
        this.currentGoal = null;
        this.verboseMode = verboseMode;
        this.LAST_ITERATION_INFO = new IterationInfo(this);
    }

    EnginePlain(_Prover prover, _AbstractGoal goal, boolean verboseMode) {
        this(prover, goal, null, verboseMode);
        this.stack = new DFStack(this, verboseMode, true);
    }

    private void reset() {
        this.result = null;
        this.currentGoal = null;
        this.stack = this.stack.newInstance();
        this.LAST_ITERATION_INFO.reset();
    }

    private void intiIterationInfo(_AbstractRule appliedRule) {
        if (this.LAST_ITERATION_INFO.move != IterationInfo.Move.OR_BRANCH_POINT_SEARCH && this.LAST_ITERATION_INFO.move != IterationInfo.Move.AND_BRANCH_POINT_SEARCH) {
            this.stack.restored_DFStackNode = null;
        }
        this.LAST_ITERATION_INFO.applied_rule = appliedRule;
        this.LAST_ITERATION_INFO.current_node_set_status = null;
        this.LAST_ITERATION_INFO.backtrack_point_added = false;
        this.LAST_ITERATION_INFO.branch_point_added = false;
        ++this.LAST_ITERATION_INFO.number_of_iterations;
    }

    _AbstractGoal getLastIterationGeneratedNodeSet() {
        return this.currentGoal == null ? null : this.currentGoal.nodeSet;
    }

    _AbstractGoal getInitialGoal() {
        return this.goal;
    }

    ProofSearchResult getResult() {
        return this.result;
    }

    ProofSearchResult searchProof() {
        this.reset();
        this.LAST_ITERATION_INFO.move = IterationInfo.Move.INITIAL_STATE;
        this.currentGoal = new GoalNode(this, this.goal.clone());
        this.result = null;
        if (this.verboseMode) {
            VerboseModeSupport.print_InitialSetInfo(this.LAST_ITERATION_INFO, this.stack, this.currentGoal);
        }
        boolean finished = false;
        _AbstractRule nextRule = this.strategy.nextRule(this.currentGoal.nodeSet, this.LAST_ITERATION_INFO);
        while (!finished) {
            RuleType ruleType = RuleType.getType(nextRule);
            this.intiIterationInfo(nextRule);
            switch (ruleType) {
                case REGULAR: {
                    this.currentGoal = this.apply_RegularRule((_RegularRule)nextRule);
                    nextRule = this.strategy.nextRule(this.currentGoal.nodeSet, this.LAST_ITERATION_INFO);
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.REGULAR_RULE_APPLICATION;
                    break;
                }
                case RESTORED_REGULAR: {
                    this.currentGoal = new GoalNode(this, ((DFStackNode_RegularRule)nextRule).nextSubgoal());
                    nextRule = this.strategy.nextRule(this.currentGoal.nodeSet, this.LAST_ITERATION_INFO);
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.RESTORED_REGULAR_RULE_APPLICATION;
                    break;
                }
                case BRANCH_EXISTS: {
                    this.currentGoal = this.apply_BranchExistsRule((_BranchExistsRule)nextRule);
                    nextRule = this.strategy.nextRule(this.currentGoal.nodeSet, this.LAST_ITERATION_INFO);
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.BRANCH_EXISTS_RULE_APPLICATION;
                    break;
                }
                case RESTORED_BRANCH_EXISTS: {
                    this.currentGoal = new GoalNode(this, ((DFStackNode_BranchExistsRule)nextRule).nextBranchExistsSubgoal());
                    nextRule = this.strategy.nextRule(this.currentGoal.nodeSet, this.LAST_ITERATION_INFO);
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.RESTORED_BRANCH_EXISTS_RULE_APPLICATION;
                    break;
                }
                case META_BACKTRACK_RULE: {
                    nextRule = this.apply_MetaBackTrackRule((_MetaBacktrackRule)nextRule);
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.META_BACKTRACK_RULE_APPLICATION;
                    break;
                }
                case RESTORED_META_BACKTRACK_RULE: {
                    nextRule = ((DFStackNode_MetaBacktrackRule)nextRule).nextRule();
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.RESTORED_META_BACKTRACK_RULE_APPLICATION;
                    break;
                }
                case FORCE_BRANCH_FAILURE: {
                    this.apply_ForceBranchFailure((ForceBranchFailure)nextRule);
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.FORCE_BRANCH_FAILURE_APPLICATION;
                    nextRule = new OR_BRANCH_POINT_SEARCH();
                    break;
                }
                case FORCE_BRANCH_SUCCESS: {
                    this.apply_ForceBranchSuccess((ForceBranchSuccess)nextRule);
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.FORCE_BRANCH_SUCCESS_APPLICATION;
                    nextRule = new AND_BRANCH_POINT_SEARCH();
                    break;
                }
                case AND_BRANCH_POINT_SEARCH: {
                    DFStackNode_RegularRule restoredBranchNode = this.stack.restorePreviousBranchPoint();
                    if (restoredBranchNode == null) {
                        this.result = ProofSearchResult.SUCCESS;
                        finished = true;
                        nextRule = null;
                    } else {
                        this.currentGoal = restoredBranchNode.getPremiseGoalNode();
                        nextRule = restoredBranchNode;
                    }
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.AND_BRANCH_POINT_SEARCH;
                    break;
                }
                case OR_BRANCH_POINT_SEARCH: {
                    DFStackNode restored = this.stack.restorePreviousBacktrackPoint();
                    if (restored == null) {
                        this.result = ProofSearchResult.FAILURE;
                        finished = true;
                        nextRule = null;
                    } else {
                        this.currentGoal = restored instanceof DFStackNode_BranchExistsRule ? ((DFStackNode_BranchExistsRule)restored).getPremiseGoalNode() : ((DFStackNode_MetaBacktrackRule)restored).getPremiseGoalNode();
                        nextRule = restored;
                    }
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.OR_BRANCH_POINT_SEARCH;
                    break;
                }
                case CLASH_DETECTION_RULE: {
                    this.apply_ClashDetectionRule((_ClashDetectionRule)nextRule);
                    this.LAST_ITERATION_INFO.move = IterationInfo.Move.CLASH_DETECTION_RULE_APPLICATION;
                    if (this.LAST_ITERATION_INFO.current_node_set_status == ProofSearchResult.SUCCESS) {
                        nextRule = new AND_BRANCH_POINT_SEARCH();
                        break;
                    }
                    nextRule = this.strategy.nextRule(this.currentGoal.nodeSet, this.LAST_ITERATION_INFO);
                    break;
                }
                default: {
                    throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED_arg, (Object)ruleType);
                }
            }
            if (!this.verboseMode) continue;
            VerboseModeSupport.print_IterationInfo(this.LAST_ITERATION_INFO, this.stack, ruleType, nextRule, this.currentGoal);
        }
        return this.result;
    }

    GoalNode apply_RegularRule(_RegularRule ruleToApply) {
        if (ruleToApply instanceof _OnRuleCompletedListener) {
            this.stack.addOnCompletedRuleListener((_OnRuleCompletedListener)((Object)ruleToApply));
        }
        GoalNode result = null;
        if (ruleToApply.numberOfSubgoals() > 1) {
            DFStackNode_RegularRule branchNode = this.stack.addBranchNode(ruleToApply, this.currentGoal);
            this.LAST_ITERATION_INFO.branch_point_added = true;
            return new GoalNode(this, branchNode.nextSubgoal());
        }
        result = new GoalNode(this, ruleToApply.nextSubgoal());
        return result;
    }

    GoalNode apply_BranchExistsRule(_BranchExistsRule ruleToApply) {
        GoalNode result = null;
        if (ruleToApply instanceof _OnRuleCompletedListener) {
            this.stack.addOnCompletedRuleListener((_OnRuleCompletedListener)((Object)ruleToApply));
        }
        if (ruleToApply.numberOfBranchExistsSubgoals() > 1) {
            DFStackNode_BranchExistsRule dfb = this.stack.addBranchExistsNode(ruleToApply, this.currentGoal);
            this.LAST_ITERATION_INFO.backtrack_point_added = true;
            result = new GoalNode(this, dfb.nextBranchExistsSubgoal());
        } else {
            result = new GoalNode(this, ruleToApply.nextBranchExistsSubgoal());
        }
        return result;
    }

    _AbstractRule apply_MetaBackTrackRule(_MetaBacktrackRule ruleToApply) {
        _AbstractRule result = null;
        if (ruleToApply instanceof _OnRuleCompletedListener) {
            this.stack.addOnCompletedRuleListener((_OnRuleCompletedListener)((Object)ruleToApply));
        }
        if (ruleToApply.totalNumberOfRules() > 1) {
            DFStackNode_MetaBacktrackRule backtrackNode = this.stack.addMetaBacktrackNode(ruleToApply, this.currentGoal);
            result = backtrackNode.nextRule();
            this.LAST_ITERATION_INFO.backtrack_point_added = true;
        } else {
            result = ruleToApply.nextRule();
        }
        return result;
    }

    void apply_ClashDetectionRule(_ClashDetectionRule ruleToApply) {
        if (ruleToApply instanceof _OnRuleCompletedListener) {
            this.stack.addOnCompletedRuleListener((_OnRuleCompletedListener)((Object)ruleToApply));
        }
        _ClashDetectionRule application = ruleToApply;
        this.LAST_ITERATION_INFO.current_node_set_status = application.status();
    }

    void apply_ForceBranchSuccess(ForceBranchSuccess ruleToApply) {
        if (ruleToApply instanceof _OnRuleCompletedListener) {
            this.stack.addOnCompletedRuleListener((_OnRuleCompletedListener)((Object)ruleToApply));
        }
        this.LAST_ITERATION_INFO.current_node_set_status = ProofSearchResult.SUCCESS;
    }

    void apply_ForceBranchFailure(ForceBranchFailure ruleToApply) {
        if (ruleToApply != null && ruleToApply instanceof _OnRuleCompletedListener) {
            this.stack.addOnCompletedRuleListener((_OnRuleCompletedListener)((Object)ruleToApply));
        }
        this.LAST_ITERATION_INFO.current_node_set_status = ProofSearchResult.FAILURE;
    }

    String getStackTrace() {
        return this.stack.getStackTrace();
    }
}

