/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.DFStack;
import jtabwb.engine.DFStackNode;
import jtabwb.engine.DFStackNode_BranchExistsRule;
import jtabwb.engine.DFStackNode_MetaBacktrackRule;
import jtabwb.engine.DFStackNode_RegularRule;
import jtabwb.engine.EnginePlain;
import jtabwb.engine.EngineTrace;
import jtabwb.engine.GoalNode;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.RuleType;
import jtabwb.engine.Trace;
import jtabwb.engine.TraceNode;
import jtabwb.engine.TraceStack;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._Prover;
import jtabwb.engine._RegularRule;
import jtabwb.util.ImplementationError;

class DFStackWithTrace
extends DFStack {
    private int nodeCounter = 0;
    boolean isStackModified = false;
    TraceNode currentTraceNode = null;
    TraceNode headOfTrace = null;
    TraceStack traceStack = new TraceStack();

    public DFStackWithTrace(EngineTrace engine, boolean verboseMode) {
        super(engine, verboseMode, false);
    }

    @Override
    DFStack newInstance() {
        return new DFStackWithTrace((EngineTrace)this.engine, this.verboseMode);
    }

    @Override
    DFStackNode_RegularRule addBranchNode(_RegularRule rule, GoalNode currentGoal) {
        this.isStackModified = true;
        return super.addBranchNode(rule, currentGoal);
    }

    @Override
    DFStackNode_MetaBacktrackRule addMetaBacktrackNode(_MetaBacktrackRule rule, GoalNode currentGoal) {
        this.isStackModified = true;
        return super.addMetaBacktrackNode(rule, currentGoal);
    }

    @Override
    DFStackNode_BranchExistsRule addBranchExistsNode(_BranchExistsRule rule, GoalNode currentGoal) {
        this.isStackModified = true;
        return super.addBranchExistsNode(rule, currentGoal);
    }

    void traceRule(EnginePlain engine, _AbstractGoal premiseOfRuleApplication, _AbstractRule rule) {
        TraceNode newTraceNode = new TraceNode(premiseOfRuleApplication, this.traceStack.nodeGeneratingPremise, rule, this.currentTraceNode, this.nodeCounter++);
        if (this.currentTraceNode != null) {
            this.currentTraceNode.addChild(newTraceNode);
        } else {
            this.headOfTrace = newTraceNode;
        }
        this.currentTraceNode = newTraceNode;
        if (this.isStackModified) {
            this.traceStack.pushWithDFStackModified(newTraceNode, this.df_head);
        } else {
            this.traceStack.pushWithDFStackUnchanged(newTraceNode);
        }
        RuleType ruleType = RuleType.getType(rule);
        switch (ruleType) {
            case CLASH_DETECTION_RULE: 
            case FORCE_BRANCH_FAILURE: 
            case FORCE_BRANCH_SUCCESS: {
                newTraceNode.status = engine.LAST_ITERATION_INFO.current_node_set_status;
                break;
            }
            case BRANCH_EXISTS: 
            case REGULAR: 
            case META_BACKTRACK_RULE: {
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED_arg, ruleType.name());
            }
        }
        this.isStackModified = false;
    }

    @Override
    DFStackNode_RegularRule restorePreviousBranchPoint() {
        this.currentTraceNode = this.traceStack.restoreBranchPoint(this.df_lastBranch);
        return super.restorePreviousBranchPoint();
    }

    @Override
    DFStackNode restorePreviousBacktrackPoint() {
        this.currentTraceNode = this.traceStack.restoreBacktrackPoint(this.df_lastBacktrack);
        return super.restorePreviousBacktrackPoint();
    }

    public Trace getTrace(_AbstractGoal initialNodeSet, _Prover prover, ProofSearchResult result) {
        TraceNode headOfTrace = this.traceStack.closeTrace(result);
        return new Trace(initialNodeSet, prover, headOfTrace, result);
    }
}

