/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.DFStack;
import jtabwb.engine.DFStackNode;
import jtabwb.engine.GoalNode;
import jtabwb.engine.NoSuchBacktrackRuleException;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._OnRuleResumedListener;

class DFStackNode_MetaBacktrackRule
extends DFStackNode
implements _MetaBacktrackRule {
    int totalNumberOfRulesToTry;
    int indexOfNextRule;

    DFStackNode_MetaBacktrackRule(DFStack stack, _MetaBacktrackRule appliedRule, GoalNode currentGoal, boolean applyOnResume) {
        super(stack, appliedRule, currentGoal);
        this.totalNumberOfRulesToTry = appliedRule.totalNumberOfRules();
        this.indexOfNextRule = 0;
        this.requireOnResumeInvocation = applyOnResume && appliedRule instanceof _OnRuleResumedListener;
    }

    int getIndexOfLastTreatedRule() {
        return this.indexOfNextRule - 1;
    }

    int indexOfLastTreatedRule() {
        return this.indexOfNextRule - 1;
    }

    int indexOfNextRule() {
        return this.indexOfNextRule;
    }

    int numberOfRulesToTry() {
        return this.totalNumberOfRulesToTry - this.indexOfNextRule;
    }

    @Override
    public String name() {
        return this.appliedRule.name();
    }

    @Override
    public _AbstractGoal goal() {
        return ((_MetaBacktrackRule)this.appliedRule).goal();
    }

    @Override
    public int totalNumberOfRules() {
        return ((_MetaBacktrackRule)this.appliedRule).totalNumberOfRules();
    }

    @Override
    public _AbstractRule nextRule() throws NoSuchBacktrackRuleException {
        ++this.indexOfNextRule;
        _AbstractRule result = ((_MetaBacktrackRule)this.appliedRule).nextRule();
        if (this.numberOfRulesToTry() == 0) {
            this.stack.pop(this);
        }
        return result;
    }

    @Override
    public boolean hasNextRule() {
        return ((_MetaBacktrackRule)this.appliedRule).hasNextRule();
    }

    @Override
    void applyOnResume() {
        ((_OnRuleResumedListener)this.appliedRule).onResumed();
    }

    @Override
    boolean isCompleted() {
        return !((_MetaBacktrackRule)this.appliedRule).hasNextRule();
    }

    public String toString() {
        return "OR branch point: META-BACKTRACK rule " + this.appliedRule.name() + ", idx of next rule [" + this.indexOfNextRule + "/" + this.totalNumberOfRulesToTry + "]";
    }
}

