/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.DFStackNode;
import jtabwb.engine.DFStackNode_BranchExistsRule;
import jtabwb.engine.DFStackNode_MetaBacktrackRule;
import jtabwb.engine.DFStackNode_RegularRule;
import jtabwb.engine.EnginePlain;
import jtabwb.engine.GoalNode;
import jtabwb.engine.OnCompletedRuleHandler;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._OnRuleCompletedListener;
import jtabwb.engine._RegularRule;

class DFStack {
    boolean verboseMode = true;
    boolean applyOnResume = true;
    int current_stack_size = 0;
    int max_stack_size = 0;
    long number_of_restored_backtrack_points = 0L;
    long number_of_restored_branch_points = 0L;
    DFStackNode restored_DFStackNode;
    DFStackNode df_head;
    DFStackNode df_lastBacktrack;
    DFStackNode df_lastBranch;
    EnginePlain engine;
    OnCompletedRuleHandler onCompletedRuleHandler = new OnCompletedRuleHandler(this);

    DFStack(EnginePlain engine, boolean verboseMode, boolean applyOnResume) {
        this.engine = engine;
        this.verboseMode = verboseMode;
        this.applyOnResume = applyOnResume;
        this.df_head = null;
        this.df_lastBacktrack = null;
        this.df_lastBranch = null;
        this.current_stack_size = 0;
        this.max_stack_size = 0;
        this.number_of_restored_backtrack_points = 0L;
        this.number_of_restored_branch_points = 0L;
        this.restored_DFStackNode = null;
    }

    DFStack newInstance() {
        return new DFStack(this.engine, this.verboseMode, true);
    }

    void pop(DFStackNode node) {
        this.df_head = node.df_previousNode;
        this.current_stack_size = node.node_height - 1;
        this.df_lastBranch = node.df_previousBranch;
        this.df_lastBacktrack = node.df_previousBacktrack;
    }

    private void push(DFStackNode node) {
        node.node_height = ++this.current_stack_size;
        node.generated_at_iteration = this.engine.LAST_ITERATION_INFO.number_of_iterations;
        node.df_previousNode = this.df_head;
        node.df_previousBranch = this.df_lastBranch;
        node.df_previousBacktrack = this.df_lastBacktrack;
        this.df_head = node;
        this.max_stack_size += this.max_stack_size < this.current_stack_size ? 1 : 0;
    }

    DFStackNode_RegularRule addBranchNode(_RegularRule regularRuleApplication, GoalNode currentGoal) {
        DFStackNode_RegularRule node = new DFStackNode_RegularRule(this, regularRuleApplication, currentGoal, this.applyOnResume);
        this.push(node);
        this.df_lastBranch = this.df_head;
        return node;
    }

    DFStackNode_MetaBacktrackRule addMetaBacktrackNode(_MetaBacktrackRule metaBacktrackRuleApplication, GoalNode currentGoal) {
        DFStackNode_MetaBacktrackRule node = new DFStackNode_MetaBacktrackRule(this, metaBacktrackRuleApplication, currentGoal, this.applyOnResume);
        this.push(node);
        this.df_lastBacktrack = this.df_head;
        return node;
    }

    DFStackNode_BranchExistsRule addBranchExistsNode(_BranchExistsRule branchExistsRuleApplication, GoalNode currentGoal) {
        DFStackNode_BranchExistsRule node = new DFStackNode_BranchExistsRule(this, branchExistsRuleApplication, currentGoal, this.applyOnResume);
        this.push(node);
        this.df_lastBacktrack = this.df_head;
        return node;
    }

    boolean isEmpty() {
        return this.df_head == null;
    }

    DFStackNode restorePreviousBacktrackPoint() {
        if (this.df_lastBacktrack == null) {
            return null;
        }
        DFStackNode activeBacktrackPoint = this.df_lastBacktrack;
        boolean continueSearch = true;
        do {
            ++this.number_of_restored_backtrack_points;
            if (activeBacktrackPoint.requireOnResumeInvocation) {
                activeBacktrackPoint.applyOnResume();
                if (activeBacktrackPoint.isCompleted()) {
                    activeBacktrackPoint = activeBacktrackPoint.df_previousBacktrack;
                    continueSearch = activeBacktrackPoint != null;
                    continue;
                }
                continueSearch = false;
                continue;
            }
            continueSearch = false;
        } while (continueSearch);
        if (activeBacktrackPoint == null) {
            this.onCompletedRuleHandler.notify(ProofSearchResult.FAILURE, 0);
            this.restored_DFStackNode = null;
            this.df_head = null;
            this.df_lastBacktrack = null;
            this.df_lastBranch = null;
            return null;
        }
        this.onCompletedRuleHandler.notify(ProofSearchResult.FAILURE, activeBacktrackPoint.node_height);
        this.df_head = activeBacktrackPoint;
        this.df_lastBacktrack = activeBacktrackPoint;
        this.df_lastBranch = activeBacktrackPoint.df_previousBranch;
        this.current_stack_size = activeBacktrackPoint.node_height;
        this.restored_DFStackNode = activeBacktrackPoint;
        this.restored_DFStackNode = this.df_head;
        return this.restored_DFStackNode;
    }

    DFStackNode_RegularRule restorePreviousBranchPoint() {
        if (this.df_lastBranch == null) {
            return null;
        }
        DFStackNode activeBranchPoint = this.df_lastBranch;
        boolean continueSearch = true;
        do {
            ++this.number_of_restored_branch_points;
            if (activeBranchPoint.requireOnResumeInvocation) {
                activeBranchPoint.applyOnResume();
                if (activeBranchPoint.isCompleted()) {
                    activeBranchPoint = activeBranchPoint.df_previousBranch;
                    continueSearch = activeBranchPoint != null;
                    continue;
                }
                continueSearch = false;
                continue;
            }
            continueSearch = false;
        } while (continueSearch);
        if (activeBranchPoint == null) {
            this.onCompletedRuleHandler.notify(ProofSearchResult.SUCCESS, 0);
            this.restored_DFStackNode = null;
            this.df_head = null;
            this.df_lastBacktrack = null;
            this.df_lastBranch = null;
            return null;
        }
        this.onCompletedRuleHandler.notify(ProofSearchResult.SUCCESS, activeBranchPoint.node_height);
        this.df_head = activeBranchPoint;
        this.df_lastBacktrack = activeBranchPoint.df_previousBacktrack;
        this.df_lastBranch = activeBranchPoint;
        this.current_stack_size = activeBranchPoint.node_height;
        this.restored_DFStackNode = activeBranchPoint;
        return (DFStackNode_RegularRule)this.df_head;
    }

    void addOnCompletedRuleListener(_OnRuleCompletedListener listener) {
        this.onCompletedRuleHandler.add(listener);
    }

    public String toString() {
        return "DFStack: current stack_size = " + this.current_stack_size + "\n" + this.getStackTrace();
    }

    public String getStackTrace() {
        if (this.df_head == null) {
            return "  <EMPTY>";
        }
        Object str = null;
        DFStackNode current = this.df_head;
        do {
            str = str == null ? "" : str + "\n";
            str = (String)str + "  <" + current.node_height + "> " + current.toString();
        } while ((current = current.df_previousNode) != null);
        return str;
    }
}

