/*
 * Decompiled with CFR 0.152.
 */
package ferram.rtoptions;

import ferram.messages.MessageManager;
import ferram.rtoptions.ArgumentStatus;
import ferram.rtoptions.ImplementationError;
import ferram.rtoptions.NamedArgumentsSet;
import ferram.rtoptions.RTOption;
import ferram.rtoptions.RTOptionArgumentException;
import ferram.rtoptions.RTOptionDefinitionException;
import ferram.rtoptions.RTOptionManagementException;
import ferram.rtoptions.RTOptionStatusException;
import ferram.rtoptions.RTOptionUndefinedValue;
import ferram.rtoptions._NamedArgument;
import ferram.rtoptions._RTOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;

public class RTOptions {
    private static final String PROPERTIES_BUNDLE_NAME = "ferram.rtoptions.messages";
    private final HashMap<String, _RTOption> options = new HashMap();
    private final HashSet<_RTOption> definedOptions = new HashSet();
    private final HashMap<_RTOption, Object> values = new HashMap();
    private final LinkedList<_RTOption[]> incompatile = new LinkedList();
    private final HashMap<_RTOption, NamedArgumentsSet<?>> arguments = new HashMap();
    private MessageManager messageManager;

    public RTOptions(_RTOption[] availableOptions) {
        if (availableOptions == null) {
            throw new RTOptionManagementException("Argument cannot be null");
        }
        for (_RTOption option : availableOptions) {
            this.add(option);
        }
        this.messageManager = new MessageManager(PROPERTIES_BUNDLE_NAME);
    }

    public RTOptions() {
        this(new RTOption[0]);
    }

    public RTOptions(Collection<? extends _RTOption> options) {
        this(options == null ? null : options.toArray(new _RTOption[options.size()]));
    }

    public void add(_RTOption option) {
        if (this.options.containsKey(option.getName())) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("already.defined.option", option.getName()));
        }
        this.options.put(option.getName(), option);
    }

    public _RTOption add(String name, ArgumentStatus status) throws RTOptionDefinitionException {
        if (name == null || status == null) {
            throw new RTOptionDefinitionException("Name and status cannot be null");
        }
        if (this.options.containsKey(name)) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("already.defined.option", name));
        }
        RTOption opt = new RTOption(name, status);
        this.add(opt);
        return opt;
    }

    public void addAll(_RTOption[] options) {
        if (options != null) {
            for (_RTOption opt : options) {
                this.add(opt);
            }
        }
    }

    public void addAll(Collection<? extends _RTOption> options) {
        if (options != null) {
            for (_RTOption _RTOption2 : options) {
                this.add(_RTOption2);
            }
        }
    }

    public _RTOption addBooleanOption(String name) throws RTOptionDefinitionException {
        return this.add(name, ArgumentStatus.NO_ARGUMENT);
    }

    public _RTOption addIntOption(String name) throws RTOptionDefinitionException {
        return this.add(name, ArgumentStatus.INT_ARGUMENT);
    }

    public _RTOption addCharOption(String name) throws RTOptionDefinitionException {
        return this.add(name, ArgumentStatus.CHAR_ARGUMENT);
    }

    public _RTOption addDoubleOption(String name) throws RTOptionDefinitionException {
        return this.add(name, ArgumentStatus.DOUBLE_ARGUMENT);
    }

    public _RTOption addStringOption(String name) throws RTOptionDefinitionException {
        return this.add(name, ArgumentStatus.STRING_ARGUMENT);
    }

    public _RTOption addGenericArgumentOption(String name) throws RTOptionDefinitionException {
        return this.add(name, ArgumentStatus.GENERIC_ARGUMENT);
    }

    public _RTOption addNamedArgumentOption(String name) throws RTOptionDefinitionException {
        return this.add(name, ArgumentStatus.NAMED_ARGUMENT);
    }

    public _RTOption addNamedArgumentOption(String name, NamedArgumentsSet<?> argSets) throws RTOptionDefinitionException {
        _RTOption opt = this.add(name, ArgumentStatus.NAMED_ARGUMENT);
        this.arguments.put(opt, argSets);
        return opt;
    }

    public _RTOption addNamedArgumentOption(_RTOption opt, NamedArgumentsSet<?> argSets) throws RTOptionDefinitionException {
        if (this.options.containsKey(opt.getName())) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("already.defined.option", opt.getName()));
        }
        this.add(opt);
        this.arguments.put(opt, argSets);
        return opt;
    }

    public void addNamedArgumentsFor(_RTOption option, NamedArgumentsSet<?> argumentManger) {
        if (this.options == null) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("options.cannot.be.null"));
        }
        if (option.getArgumentStatus() != ArgumentStatus.NAMED_ARGUMENT) {
            throw new RTOptionStatusException(this.messageManager.getMsg("option.wrong.argument.status", new Object[]{option.getName(), ArgumentStatus.NAMED_ARGUMENT, option.getArgumentStatus().name()}));
        }
        if (argumentManger == null) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("arguments.manager.cannot.be.null"));
        }
        if (this.arguments.containsKey(option)) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("arguments.manager.already.defined", option.getName()));
        }
        this.arguments.put(option, argumentManger);
    }

    private RTOptionArgumentException buildArgumentStatusException(_RTOption option, ArgumentStatus required) {
        return new RTOptionArgumentException(this.messageManager.getMsg("option.wrong.argument.status", option.getName(), required.name(), option.getArgumentStatus().name()));
    }

    public _RTOption[] checkCompatibility() {
        if (this.incompatile != null) {
            for (_RTOption[] incompSet : this.incompatile) {
                boolean testIncompatibility = true;
                for (_RTOption opt : incompSet) {
                    if (this.definedOptions.contains(opt)) continue;
                    testIncompatibility = false;
                    break;
                }
                if (!testIncompatibility) continue;
                return incompSet;
            }
        }
        return null;
    }

    public boolean contains(String optionName) {
        return this.options.containsKey(optionName);
    }

    public boolean contains(_RTOption option) {
        return this.options.values().contains(option);
    }

    private void _defineOptionValue(_RTOption option, ArgumentStatus status, Object value) {
        if (option == null) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("option.cannot.be.null"));
        }
        if (option.getArgumentStatus() != status) {
            throw new RTOptionStatusException(this.messageManager.getMsg("option.wrong.argument.status", option.getName(), status.name(), option.getArgumentStatus().name()));
        }
        if (!this.options.containsValue(option)) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("option.unknown", option.getName()));
        }
        if (value == null) {
            throw new RTOptionArgumentException(this.messageManager.getMsg("value.cannot.be.null"));
        }
        this.definedOptions.add(option);
        switch (status) {
            case CHAR_ARGUMENT: {
                this.values.put(option, (Character)value);
                break;
            }
            case DOUBLE_ARGUMENT: {
                this.values.put(option, (Double)value);
                break;
            }
            case INT_ARGUMENT: {
                this.values.put(option, (Integer)value);
                break;
            }
            case STRING_ARGUMENT: {
                this.values.put(option, (String)value);
                break;
            }
            case GENERIC_ARGUMENT: {
                this.values.put(option, value);
                break;
            }
            default: {
                throw new ImplementationError();
            }
        }
    }

    public void defineBooleanOption(_RTOption option) {
        if (option == null) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("option.cannot.be.null"));
        }
        if (option.getArgumentStatus() != ArgumentStatus.NO_ARGUMENT) {
            throw new RTOptionStatusException(this.messageManager.getMsg("option.wrong.argument.status", new Object[]{option.getName(), ArgumentStatus.NO_ARGUMENT, option.getArgumentStatus().name()}));
        }
        this.definedOptions.add(option);
    }

    public void defineBooleanOptions(_RTOption[] options) {
        if (options == null) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("options.cannot.be.null"));
        }
        if (options != null) {
            for (_RTOption opt : options) {
                this.defineBooleanOption(opt);
            }
        }
    }

    public void defineBooleanOptions(Collection<? extends _RTOption> options) {
        if (options == null) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("options.cannot.be.null"));
        }
        if (options != null) {
            for (_RTOption _RTOption2 : options) {
                this.defineBooleanOption(_RTOption2);
            }
        }
    }

    public void defineGenericOption(_RTOption option, Object value) {
        this._defineOptionValue(option, ArgumentStatus.GENERIC_ARGUMENT, value);
    }

    public void defineIntOption(_RTOption option, int value) {
        this._defineOptionValue(option, ArgumentStatus.INT_ARGUMENT, new Integer(value));
    }

    public void defineCharOption(_RTOption option, char value) {
        this._defineOptionValue(option, ArgumentStatus.CHAR_ARGUMENT, new Character(value));
    }

    public void defineDoubleOption(_RTOption option, double value) {
        this._defineOptionValue(option, ArgumentStatus.DOUBLE_ARGUMENT, new Double(value));
    }

    public void defineStringOption(_RTOption option, String value) {
        this._defineOptionValue(option, ArgumentStatus.STRING_ARGUMENT, value);
    }

    public _NamedArgument<?> defineNamedArgumentOption(_RTOption option, String namedArgumentValue) {
        if (option == null) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("option.cannot.be.null"));
        }
        if (option.getArgumentStatus() != ArgumentStatus.NAMED_ARGUMENT) {
            throw new RTOptionStatusException(this.messageManager.getMsg("option.wrong.argument.status", option.getName(), ArgumentStatus.NAMED_ARGUMENT.name(), option.getArgumentStatus().name()));
        }
        if (!this.options.containsValue(option)) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("option.unknown", option.getName()));
        }
        if (namedArgumentValue == null) {
            throw new RTOptionArgumentException(this.messageManager.getMsg("value.cannot.be.null"));
        }
        NamedArgumentsSet<?> argMng = this.arguments.get(option);
        if (argMng == null) {
            throw new RTOptionManagementException(this.messageManager.getMsg("arguments.not.specified", option.getName()));
        }
        _NamedArgument<?> value = argMng.searchByName(namedArgumentValue);
        if (value == null) {
            throw new RTOptionArgumentException(this.messageManager.getMsg("unknown.argument.value", namedArgumentValue, option.getName()));
        }
        this.definedOptions.add(option);
        this.values.put(option, value);
        return value;
    }

    public _NamedArgument<?> defineNamedArgumentOption(_RTOption option, _NamedArgument<?> namedArgument) {
        if (option == null) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("option.cannot.be.null"));
        }
        if (option.getArgumentStatus() != ArgumentStatus.NAMED_ARGUMENT) {
            throw new RTOptionStatusException(this.messageManager.getMsg("option.wrong.argument.status", option.getName(), ArgumentStatus.NAMED_ARGUMENT.name(), option.getArgumentStatus().name()));
        }
        if (!this.options.containsValue(option)) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("option.unknown", option.getName()));
        }
        if (namedArgument == null) {
            throw new RTOptionArgumentException(this.messageManager.getMsg("value.cannot.be.null"));
        }
        NamedArgumentsSet<?> argMng = this.arguments.get(option);
        if (argMng == null) {
            throw new RTOptionManagementException(this.messageManager.getMsg("arguments.not.specified", option.getName()));
        }
        if (argMng.searchByName(namedArgument.getName()) == null) {
            throw new RTOptionArgumentException(this.messageManager.getMsg("unknown.argument.value", namedArgument.getName(), option.getName()));
        }
        this.definedOptions.add(option);
        this.values.put(option, namedArgument);
        return namedArgument;
    }

    public <T extends _RTOption> Collection<T> getDefinedOptionsFrom(T[] options) {
        Vector<T> defined = new Vector<T>();
        if (options == null) {
            return defined;
        }
        for (T opt : options) {
            if (!this.isDefined((_RTOption)opt)) continue;
            defined.add(opt);
        }
        return defined;
    }

    public Collection<_RTOption> getDefinedOptions() {
        LinkedList<_RTOption> defined = new LinkedList<_RTOption>();
        for (_RTOption opt : this.definedOptions) {
            defined.add(opt);
        }
        return defined;
    }

    public Collection<_RTOption> getOptions() {
        return this.options.values();
    }

    public NamedArgumentsSet<?> getNamedArgumentsManger(_RTOption option) {
        if (option.getArgumentStatus() != ArgumentStatus.NAMED_ARGUMENT) {
            throw this.buildArgumentStatusException(option, ArgumentStatus.NAMED_ARGUMENT);
        }
        return this.arguments.get(option);
    }

    private Object _getValue(_RTOption option, ArgumentStatus status) {
        if (option == null) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("option.cannot.be.null"));
        }
        if (option.getArgumentStatus() != status) {
            throw new RTOptionStatusException(this.messageManager.getMsg("option.wrong.argument.status", option.getName(), status.name(), option.getArgumentStatus().name()));
        }
        if (!this.options.containsValue(option)) {
            throw new RTOptionDefinitionException(this.messageManager.getMsg("option.unknown", option.getName()));
        }
        return this.values.get(option);
    }

    public Object getGenericValue(_RTOption option) {
        Object value = this._getValue(option, ArgumentStatus.GENERIC_ARGUMENT);
        if (value == null) {
            throw new RTOptionUndefinedValue(this.messageManager.getMsg("option.undefined.value", option.getName()));
        }
        return value;
    }

    public _NamedArgument<?> getNamedArgumentValue(_RTOption option) {
        _NamedArgument value = (_NamedArgument)this._getValue(option, ArgumentStatus.NAMED_ARGUMENT);
        if (value == null) {
            throw new RTOptionUndefinedValue(this.messageManager.getMsg("option.undefined.value", option.getName()));
        }
        return value;
    }

    public int getIntValue(_RTOption option) {
        Integer value = (Integer)this._getValue(option, ArgumentStatus.INT_ARGUMENT);
        if (value == null) {
            throw new RTOptionUndefinedValue(this.messageManager.getMsg("option.undefined.value", option.getName()));
        }
        return value;
    }

    public char getCharValue(_RTOption option) {
        Character value = (Character)this._getValue(option, ArgumentStatus.CHAR_ARGUMENT);
        if (value == null) {
            throw new RTOptionUndefinedValue(this.messageManager.getMsg("option.undefined.value", option.getName()));
        }
        return value.charValue();
    }

    public double getDoubleValue(_RTOption option) {
        Double value = (Double)this._getValue(option, ArgumentStatus.DOUBLE_ARGUMENT);
        if (value == null) {
            throw new RTOptionUndefinedValue(this.messageManager.getMsg("option.undefined.value", option.getName()));
        }
        return value;
    }

    public String getStringValue(_RTOption option) {
        String value = (String)this._getValue(option, ArgumentStatus.STRING_ARGUMENT);
        if (value == null) {
            throw new RTOptionUndefinedValue(this.messageManager.getMsg("option.undefined.value", option.getName()));
        }
        return value;
    }

    public Collection<_RTOption[]> getIncomplatibleOptions() {
        return this.incompatile;
    }

    public static String getIncompatibityDescription(_RTOption[] incompatible) {
        MessageManager messageManager = new MessageManager(PROPERTIES_BUNDLE_NAME);
        if (incompatible != null) {
            Object str = "";
            for (int i = 0; i < incompatible.length; ++i) {
                str = (String)str + incompatible[i].getName() + (i < incompatible.length - 1 ? "," : "");
            }
            return messageManager.getMsg("incompatible.options", str);
        }
        return null;
    }

    public boolean isDefined(_RTOption option) {
        return this.definedOptions.contains(option);
    }

    public boolean remove(_RTOption option) {
        if (!this.options.containsKey(option.getName())) {
            return false;
        }
        this.options.remove(option.getName());
        this.definedOptions.remove(option);
        this.values.remove(option);
        return true;
    }

    public _RTOption searchByName(String optionName) {
        return this.options.get(optionName);
    }

    public void setIncompatible(_RTOption[] incompatible) {
        this.incompatile.add(incompatible);
    }

    public void setIncompatible(Collection<_RTOption[]> incompatible) {
        for (_RTOption[] inc : incompatible) {
            this.setIncompatible(inc);
        }
    }
}

