/*
 * Decompiled with CFR 0.152.
 */
package ferram.rtoptions;

import ferram.messages.MessageManager;
import ferram.rtoptions.ImplementationError;
import ferram.rtoptions.NamedArgument;
import ferram.rtoptions.NamedArgumentDefinitionException;
import ferram.rtoptions.RTOptionManagementException;
import ferram.rtoptions._NamedArgument;
import java.util.Arrays;
import java.util.LinkedList;

public class NamedArgumentsSet<T> {
    private final String BUNDLE_NAME = NamedArgumentsSet.class.getPackage().getName() + ".messages";
    private MessageManager messageManager = new MessageManager(this.BUNDLE_NAME);
    private LinkedList<_NamedArgument<T>> arguments;
    private _NamedArgument<T> defaultValue;
    private _NamedArgument<T> firstAdded = null;
    private _NamedArgument<T> lastAdded = null;

    public NamedArgumentsSet(_NamedArgument<T>[] arguments) {
        if (arguments == null) {
            throw new ImplementationError(ImplementationError.ARGUMENT_CANNOT_BE_NULL);
        }
        this.arguments = new LinkedList();
        for (_NamedArgument<T> arg : arguments) {
            this.arguments.add(arg);
        }
        this.firstAdded = arguments[0];
        this.lastAdded = arguments[arguments.length - 1];
    }

    public NamedArgumentsSet() {
        this.arguments = new LinkedList();
    }

    public _NamedArgument<T> add(_NamedArgument<T> arg) {
        if (arg == null) {
            throw new NamedArgumentDefinitionException(this.messageManager.getMsg("named.argument.cannot.be.null"));
        }
        if (this.searchByName(arg.getName()) != null) {
            throw new NamedArgumentDefinitionException(this.messageManager.getMsg("named.argument.already.defined", arg.getName()));
        }
        this.arguments.add(arg);
        if (this.firstAdded == null) {
            this.firstAdded = arg;
        }
        this.lastAdded = arg;
        return arg;
    }

    public void addAll(_NamedArgument<T>[] args) {
        if (args == null) {
            throw new NamedArgumentDefinitionException(this.messageManager.getMsg("named.argument.cannot.be.null"));
        }
        for (_NamedArgument<T> arg : args) {
            this.add(arg);
        }
    }

    public _NamedArgument<T> add(_NamedArgument<T> arg, boolean isDefault) {
        this.add(arg);
        if (isDefault) {
            this.defaultValue = arg;
        }
        return arg;
    }

    public _NamedArgument<T> add(String name, String description, T value) {
        if (name == null || name.length() == 0) {
            throw new NamedArgumentDefinitionException(this.messageManager.getMsg("named.argument.name.cannot.be.null.or.empty"));
        }
        if (this.searchByName(name) != null) {
            throw new NamedArgumentDefinitionException(this.messageManager.getMsg("named.argument.already.defined", name));
        }
        NamedArgument<T> arg = new NamedArgument<T>(name, description, value);
        this.add(arg);
        return arg;
    }

    public _NamedArgument<T> add(String name, String description, T value, boolean isDefault) {
        _NamedArgument<T> arg = this.add(name, description, value);
        if (isDefault) {
            this.defaultValue = arg;
        }
        return arg;
    }

    public _NamedArgument<T> searchByName(String name) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (!this.arguments.get(i).getName().equals(name)) continue;
            return this.arguments.get(i);
        }
        return null;
    }

    public _NamedArgument<T>[] getNamedArguments() {
        return this.arguments.toArray(new _NamedArgument[this.arguments.size()]);
    }

    public String getNames() {
        Object[] argNames = new String[this.arguments.size()];
        for (int i = 0; i < argNames.length; ++i) {
            argNames[i] = this.arguments.get(i).getName();
        }
        Arrays.sort(argNames);
        Object str = "";
        for (int i = 0; i < argNames.length; ++i) {
            str = (String)str + (String)argNames[i] + (this.defaultValue == null ? "" : (((String)argNames[i]).equals(this.defaultValue.getName()) ? "*" : "")) + (i < argNames.length - 1 ? ", " : "");
        }
        return str;
    }

    public _NamedArgument<T> getDefault() {
        return this.defaultValue;
    }

    public _NamedArgument<T> getFirstAdded() {
        return this.firstAdded;
    }

    public _NamedArgument<T> getLastAdded() {
        return this.lastAdded;
    }

    public boolean isEmpty() {
        return this.arguments.isEmpty();
    }

    public void setDefault(_NamedArgument<T> defaultValue) {
        boolean found = false;
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (!defaultValue.equals(this.arguments.get(i))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new RTOptionManagementException("option.value.not.found");
        }
        this.defaultValue = defaultValue;
    }

    boolean contains(_NamedArgument<T> arg) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != arg) continue;
            return true;
        }
        return false;
    }

    public String getNamedArgumentsDescription() {
        String FMT = "-%s%s%s %s";
        int maxlength = 0;
        for (int i = 0; i < this.arguments.size(); ++i) {
            _NamedArgument<T> elem = this.arguments.get(i);
            if (elem.getName().length() <= maxlength) continue;
            maxlength = elem.getName().length();
        }
        Object[] strArg = new String[this.arguments.size()];
        for (int i = 0; i < this.arguments.size(); ++i) {
            _NamedArgument<T> elem = this.arguments.get(i);
            String strName = elem.getName();
            String post = null;
            post = this.defaultValue != null && this.arguments.get(i) == this.defaultValue ? "*" : " ";
            String space = String.format("%-" + (maxlength - strName.length() + 2) + "s", " ");
            strArg[i] = String.format(FMT, strName, post, space, elem.getDescription());
        }
        Arrays.sort(strArg);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strArg.length; ++i) {
            result.append((String)strArg[i] + (i < strArg.length - 1 ? "\n" : ""));
        }
        return result.toString();
    }

    public int size() {
        return this.arguments.size();
    }
}

