/*
 * Decompiled with CFR 0.152.
 */
package ferram.CLIOptionsSupport;

import ferram.CLIOptionsSupport.LauncherOptionDefinitionException;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CLIOptionsSupport {
    private HashMap<String, LinkedList<String>> incomp = new HashMap();
    private LinkedList<LinkedList<String>> exclusionGroups = new LinkedList();
    private final String FMT = "[%s,%s] incompatible options.";
    private static final String REDEFINITION_ERROR = "CmdLineOptionBuilder ERROR - an option with name [%s] has already been defined.";

    public void addIncompatibility(String optName, String incompatibleOptName) {
        LinkedList<String> incompatible = this.incomp.get(optName);
        if (incompatible == null) {
            incompatible = new LinkedList();
            this.incomp.put(optName, incompatible);
        }
        incompatible.add(incompatibleOptName);
    }

    public void addIncompatibility(String optName, String[] incompatibleOptNames) {
        for (String opt : incompatibleOptNames) {
            this.addIncompatibility(optName, opt);
        }
    }

    public void addExclusionGroup(Option ... args) {
        LinkedList<String> g = new LinkedList<String>();
        for (Option opt : args) {
            String name = opt.getOpt();
            if (name == null) {
                name = opt.getLongOpt();
            }
            g.add(name);
        }
        this.exclusionGroups.add(g);
    }

    public void addExclusionGroup(String ... args) {
        LinkedList<String> g = new LinkedList<String>();
        for (String opt : args) {
            g.add(opt);
        }
        this.exclusionGroups.add(g);
    }

    public boolean hasIncompatibleOptions(CommandLine cmdLine) {
        return this.hasIncompatibility(cmdLine) || this.hasExcluded(cmdLine);
    }

    private boolean hasIncompatibility(CommandLine cmdLine) {
        for (String option : this.incomp.keySet()) {
            LinkedList<String> incompatible;
            if (!cmdLine.hasOption(option) || (incompatible = this.incomp.get(option)) == null) continue;
            for (String opt : incompatible) {
                if (!cmdLine.hasOption(opt)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasExcluded(CommandLine cmdLine) {
        for (LinkedList linkedList : this.exclusionGroups) {
            boolean oneDefined = false;
            for (String opt : linkedList) {
                if (!cmdLine.hasOption(opt)) continue;
                if (oneDefined) {
                    return true;
                }
                oneDefined = true;
            }
        }
        return false;
    }

    public String firstIncompatibilityDescription(CommandLine cmdLine) {
        if (this.hasIncompatibility(cmdLine)) {
            return this.stringIncomp(cmdLine);
        }
        if (this.hasExcluded(cmdLine)) {
            return this.stringExclusion(cmdLine);
        }
        return null;
    }

    private String stringIncomp(CommandLine cmdLine) {
        for (String option : this.incomp.keySet()) {
            LinkedList<String> incompatible;
            if (!cmdLine.hasOption(option) || (incompatible = this.incomp.get(option)) == null) continue;
            for (String opt : incompatible) {
                if (!cmdLine.hasOption(opt)) continue;
                return String.format("[%s,%s] incompatible options.", option, opt);
            }
        }
        return null;
    }

    private String stringExclusion(CommandLine cmdLine) {
        for (LinkedList linkedList : this.exclusionGroups) {
            String oneDefinedName = null;
            for (String opt : linkedList) {
                if (!cmdLine.hasOption(opt)) continue;
                if (oneDefinedName != null) {
                    return String.format("[%s,%s] incompatible options.", oneDefinedName, opt);
                }
                oneDefinedName = opt;
            }
        }
        return null;
    }

    public static Options buildOptions(LinkedList<Option> options) {
        return CLIOptionsSupport.buildOptions(options.toArray(new Option[options.size()]));
    }

    public static Options buildOptions(Option[] options) {
        Options optManager = new Options();
        for (Option opt : options) {
            if (optManager.getOption(opt.getOpt()) != null || optManager.getOption(opt.getLongOpt()) != null) {
                throw new LauncherOptionDefinitionException(String.format(REDEFINITION_ERROR, opt.getOpt()));
            }
            optManager.addOption(opt);
        }
        return optManager;
    }
}

