/*
 * Decompiled with CFR 0.152.
 */
package cpl.clnat.tp;

import cpl.clnat.sequent.CLNSequent;
import cpl.clnat.sequent.CLNatFormulaFactory;
import cpl.clnat.strategy.Strategy;
import cpl.clnat.tp.CtreeLatexFormatter;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.engine.ProverName;
import jtabwb.engine._Prover;
import jtabwb.engine._Strategy;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwb.tracesupport._LatexSupport;
import jtabwb.util.ImplementationError;

public class CLNProver
implements _Prover,
_LatexSupport {
    public static String CLN_DESCRIPTION = "Nbu - Natural deduction calculus for CL.";
    public static String CLN_NAME = "cln";
    public static String CLN_VERSION = "0.1";
    private ProverName proverName = new ProverName(CLN_NAME, CLN_VERSION);
    private CLNatFormulaFactory formulaFactory;
    private Strategy strategy;

    public CLNProver() {
        this.proverName.setDescription(CLN_DESCRIPTION);
    }

    public void configure(CLNatFormulaFactory formulaFactory) {
        this.formulaFactory = formulaFactory;
        this.strategy = new Strategy(this.formulaFactory);
    }

    @Override
    public _Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ProverName getProverName() {
        return this.proverName;
    }

    @Override
    public ProvabilityStatus statusFor(ProofSearchResult result) {
        switch (result) {
            case SUCCESS: {
                return ProvabilityStatus.PROVABLE;
            }
            case FAILURE: {
                return ProvabilityStatus.UNPROVABLE;
            }
        }
        throw new ImplementationError();
    }

    @Override
    public _LatexCTreeFormatter getLatexProofFormatter() {
        return new CtreeLatexFormatter();
    }

    public CLNSequent getIrreducibleSequent() {
        return this.strategy.getIrreducibleSequent();
    }
}

