/*
 * Decompiled with CFR 0.152.
 */
package cpl.clnat.strategy;

import cpl.clnat.calculus.Up_Coercion;
import cpl.clnat.calculus.Up_Elim_False;
import cpl.clnat.calculus.Up_Elim_OR;
import cpl.clnat.calculus.Up_Intro_AND;
import cpl.clnat.calculus.Up_Intro_IMPLIES;
import cpl.clnat.calculus.Up_Intro_OR;
import cpl.clnat.calculus.Up_RestartC;
import cpl.clnat.calculus.Up_RestartP;
import cpl.clnat.sequent.CLNSequent;
import cpl.clnat.sequent.CLNatFormulaFactory;
import cpl.clnat.sequent.PositiveSubformulas;
import cpl.clnat.sequent._CLNSequent;
import cpl.clnat.strategy.IrreducibleSequent;
import java.util.HashMap;
import jtabwb.engine.IterationInfo;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._Strategy;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaProposition;

public class Strategy
implements _Strategy {
    private CLNSequent irreducibleSequent;
    private CLNatFormulaFactory formulaFactory;

    public Strategy(CLNatFormulaFactory formulaFactory) {
        this.formulaFactory = formulaFactory;
        this.irreducibleSequent = null;
    }

    @Override
    public _AbstractRule nextRule(_AbstractGoal currentGoal, IterationInfo lastIteration) {
        _CLNSequent goal = (_CLNSequent)currentGoal;
        if (goal.isDownSequent()) {
            return goal.getDownExpansionPhase().getNextRuleToApply(goal);
        }
        Formula rightFormula = goal.getRight();
        if (rightFormula.isAtomic()) {
            FormulaProposition toExtract;
            BitSetOfFormulas elegibleHeadFormulas;
            if (!rightFormula.isFalse() && (elegibleHeadFormulas = PositiveSubformulas.elegibleHeadFormulas(goal, toExtract = (FormulaProposition)rightFormula)) != null) {
                return new Up_Coercion(goal, elegibleHeadFormulas.getFirst());
            }
            Cloneable elegibleHeadFormulas2 = PositiveSubformulas.elegibleHeadFormulas(goal, this.formulaFactory.getFalse());
            if (elegibleHeadFormulas2 != null) {
                return new Up_Elim_False(goal, ((BitSetOfFormulas)elegibleHeadFormulas2).getFirst());
            }
            elegibleHeadFormulas2 = PositiveSubformulas.elegibleHeadFormulasWithDisjunctivePositiveSub(goal);
            if (elegibleHeadFormulas2 != null) {
                Formula headFormula = ((BitSetOfFormulas)elegibleHeadFormulas2).getFirst();
                Formula selectedDisjunction = this.formulaFactory.positiveSubFormulasOfWithType(headFormula, FormulaType.OR_WFF).getFirst();
                return new Up_Elim_OR(goal, selectedDisjunction, headFormula);
            }
            elegibleHeadFormulas2 = PositiveSubformulas.elegibleHeadFormulasContainingRestartVariable(goal);
            if (elegibleHeadFormulas2 != null) {
                FormulaProposition restartFormula = (FormulaProposition)((HashMap)elegibleHeadFormulas2).keySet().iterator().next();
                Formula headFormula = ((BitSetOfFormulas)((HashMap)elegibleHeadFormulas2).get(restartFormula)).getFirst();
                return new Up_RestartP(goal, headFormula, restartFormula);
            }
            BitSetOfFormulas restart = goal.getRestartSet();
            for (Formula wff : restart) {
                if (!wff.isCompound()) continue;
                return new Up_RestartC(goal, wff);
            }
            this.irreducibleSequent = (CLNSequent)goal;
            return new IrreducibleSequent(goal);
        }
        switch (rightFormula.mainConnective()) {
            case AND: {
                return new Up_Intro_AND(goal, rightFormula);
            }
            case OR: {
                return new Up_Intro_OR(goal, rightFormula);
            }
            case IMPLIES: {
                return new Up_Intro_IMPLIES(goal, rightFormula);
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }

    public CLNSequent getIrreducibleSequent() {
        return this.irreducibleSequent;
    }
}

